<#--
 #%L
 Coser :: Business
 %%
 Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 %%
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as 
 published by the Free Software Foundation, either version 3 of the 
 License, or (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Lesser Public License for more details.
 
 You should have received a copy of the GNU General Lesser Public 
 License along with this program.  If not, see
 <http://www.gnu.org/licenses/lgpl-3.0.html>.
 #L%
-->
<html>
 <body>
  
  <h2>Species included in the Community indicators</h2>
  
  <p>Each community indicator is calculated including a set of species selected
  from consistency and relevance criteria. For instance, species with information
  for only part of the series are excluded. The species included in the
  calculation made for this sending are given below.</p>
  
  <p>The species groups are coded as following (letter in front of the species
  name below) : Cnidaria (n), Annelida (a), Mollusca except  Cephalopoda (o),
  Cephalopoda (m), Crustacea (c), Echinoderma (e), Pisces &amp; Agnatha (p). In the
  data table enclosed, the first character of the "Liste" field gives the species
  group for which the indicator is calculated, the letter T being used when the
  indicator is calculated for all species which are on the list independent of
  their group.</p>

  
  <#list indicatorsMap.keySet() as indicatorId>
  
    <h3>
      <#switch indicatorId>
        <#case "1">
          List 1 (full list of species)
          <#break>
        <#case "2">
          List 2  (selected species, e.g. above a certain occurrence and density threshold, to exclude rare species)
          <#break>
        <#case "3">
          List  3 (only measured species)
          <#break>
        <#default>
          ## Unknown list ? ##
      </#switch>
    </h3>

    <h4>
    <#list indicatorsMap.get(indicatorId) as indicator>
      ${indicator}<#if indicator_has_next>,</#if>
    </#list>
    </h4>
    
    <ul>
    <#list speciesMap.get(indicatorId) as species>
      <li>${species}</li>
    </#list>
    </ul>
  </#list>

</body>
</html>
