package fr.ifremer.coselmar.services.indexation;

/*
 * #%L
 * Coselmar :: Rest Services
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.io.File;
import java.io.IOException;

import fr.ifremer.coselmar.services.config.CoselmarServicesConfig;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.Version;

/**
 * @author ymartel <martel@codelutin.com>
 */
public class LuceneUtils {

    public static Analyzer analyzer;
    public static final IndexWriterConfig indexationConfig = new IndexWriterConfig(Version.LUCENE_4_10_2, getAnalyzer());
    public static IndexWriter indexWriter;

    protected CoselmarServicesConfig servicesConfig;

    public LuceneUtils(CoselmarServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    protected static Analyzer getAnalyzer() {
        if (analyzer == null) {
//            analyzer = new StandardAnalyzer();
            //Use simple analyzer to index all words and be able to search with "close word" classified in StandardAnalyzer
            analyzer = new SimpleAnalyzer();
        }
        return analyzer;

    }

    public IndexWriter getIndexWriter() throws IOException {
        if (indexWriter == null) {
            File indexDirectory = servicesConfig.getIndexDirectory();
            Directory index = NIOFSDirectory.open(indexDirectory);

            indexationConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            indexWriter = new IndexWriter(index, indexationConfig);
        }
        return indexWriter;
    }

    public void clearIndex() throws IOException {
        getIndexWriter().deleteAll();
        getIndexWriter().commit();
    }

}
