/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.persistence.entity;

import fr.ifremer.coselmar.persistence.DaoUtils;
import fr.ifremer.coselmar.persistence.SearchRequestBean;
import fr.ifremer.coselmar.persistence.entity.AbstractCoselmarUserTopiaDao;
import fr.ifremer.coselmar.persistence.entity.CoselmarUser;
import java.util.HashMap;
import java.util.List;
import org.nuiton.util.pagination.PaginationParameter;

public class CoselmarUserTopiaDao
extends AbstractCoselmarUserTopiaDao<CoselmarUser> {
    public List<CoselmarUser> findAllLikeKeywords(List<String> keywords, boolean onlyActive) {
        StringBuilder hqlBuilder = new StringBuilder("FROM " + CoselmarUser.class.getName() + " CU");
        hqlBuilder.append(" WHERE 1=1 ");
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (onlyActive) {
            String activeCondition = DaoUtils.andAttributeEquals("CU", "active", args, true);
            hqlBuilder.append(activeCondition);
        }
        if (keywords != null) {
            for (String keyword : keywords) {
                hqlBuilder.append(" AND ( 1=0 ");
                String orFirstname = DaoUtils.orAttributeLike("CU", "firstname", args, keyword);
                hqlBuilder.append(orFirstname);
                String orName = DaoUtils.orAttributeLike("CU", "name", args, keyword);
                hqlBuilder.append(orName);
                String orMail = DaoUtils.orAttributeLike("CU", "mail", args, keyword);
                hqlBuilder.append(orMail);
                String orOrganization = DaoUtils.orAttributeLike("CU", "organization", args, keyword);
                hqlBuilder.append(orOrganization);
                String orQualification = DaoUtils.orAttributeLike("CU", "qualification", args, keyword);
                hqlBuilder.append(orQualification);
                hqlBuilder.append(" ) ");
            }
        }
        List coselmarUsers = this.forHql(hqlBuilder.toString(), args).findAll();
        return coselmarUsers;
    }

    public List<CoselmarUser> findAllByExample(CoselmarUser example, boolean activeAndInactive, SearchRequestBean searchRequest) {
        List<String> keywords;
        StringBuilder hqlBuilder = new StringBuilder("FROM " + CoselmarUser.class.getName() + " CU");
        hqlBuilder.append(" WHERE 1=1 ");
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (!activeAndInactive) {
            String activeCondition = DaoUtils.andAttributeEquals("CU", "active", args, example.isActive());
            hqlBuilder.append(activeCondition);
        }
        if (example.getFirstname() != null) {
            String firstNameCondition = DaoUtils.andAttributeLike("CU", "firstname", args, example.getFirstname());
            hqlBuilder.append(firstNameCondition);
        }
        if (example.getName() != null) {
            String nameCondition = DaoUtils.andAttributeLike("CU", "name", args, example.getName());
            hqlBuilder.append(nameCondition);
        }
        if (example.getMail() != null) {
            String mailCondition = DaoUtils.andAttributeLike("CU", "mail", args, example.getMail());
            hqlBuilder.append(mailCondition);
        }
        if (example.getOrganization() != null) {
            String organizationCondition = DaoUtils.andAttributeLike("CU", "organization", args, example.getOrganization());
            hqlBuilder.append(organizationCondition);
        }
        if (example.getQualification() != null) {
            String qualificationCondition = DaoUtils.andAttributeLike("CU", "qualification", args, example.getQualification());
            hqlBuilder.append(qualificationCondition);
        }
        if (example.getRole() != null) {
            String roleCondition = DaoUtils.andAttributeEquals("CU", "role", args, (Object)example.getRole());
            hqlBuilder.append(roleCondition);
        }
        if ((keywords = searchRequest.getFullTextSearch()) != null) {
            for (String keyword : keywords) {
                hqlBuilder.append(" AND ( 1=0 ");
                String orFirstname = DaoUtils.orAttributeLike("CU", "firstname", args, keyword);
                hqlBuilder.append(orFirstname);
                String orName = DaoUtils.orAttributeLike("CU", "name", args, keyword);
                hqlBuilder.append(orName);
                String orMail = DaoUtils.orAttributeLike("CU", "mail", args, keyword);
                hqlBuilder.append(orMail);
                String orOrganization = DaoUtils.orAttributeLike("CU", "organization", args, keyword);
                hqlBuilder.append(orOrganization);
                String orQualification = DaoUtils.orAttributeLike("CU", "qualification", args, keyword);
                hqlBuilder.append(orQualification);
                hqlBuilder.append(" ) ");
            }
        }
        PaginationParameter paginationParameter = PaginationParameter.of((int)searchRequest.getPage(), (int)searchRequest.getLimit(), (String)"mail", (boolean)false);
        List coselmarUsers = this.forHql(hqlBuilder.toString(), args).find(paginationParameter);
        return coselmarUsers;
    }
}

