/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.paint;

import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.platform.cwt.adapter.GraphicsEnvironmentAdapterRegistry;
import de.intarsys.pdf.platform.cwt.adapter.IGraphicsEnvironmentAdapter;

/**
 * A color {@link IPaint} implementation.
 * 
 */
public class ColorPaint extends AbstractPaint {
	private float alphaValue;

	private PDColorSpace pdColorSpace;

	private float[] colorValues;

	protected ColorPaint(ColorPaint colorPaint) {
		alphaValue = colorPaint.alphaValue;
		colorValues = colorPaint.colorValues;
		pdColorSpace = colorPaint.pdColorSpace;
	}

	public ColorPaint(PDColorSpace pdColorSpace) {
		this.pdColorSpace = pdColorSpace;
		// colorValues is uninitialized, null must be interpreted as
		// black in the respective color space
		this.alphaValue = 1;
	}

	public IPaint copy() {
		return new ColorPaint(this);
	}

	public float getAlphaValue() {
		return alphaValue;
	}

	/**
	 * The actual color values. Remember that this may be null, indicating
	 * black.
	 * 
	 * @return The actual color values.
	 */
	public float[] getColorValues() {
		return colorValues;
	}

	public PDColorSpace getPdColorSpace() {
		return pdColorSpace;
	}

	public void setAlphaValue(float value) {
		alphaValue = value;
	}

	public void setBackgroundPaintFromGraphicsContext(
			IGraphicsContext graphicsContext) {
		IGraphicsEnvironmentAdapter adapter = GraphicsEnvironmentAdapterRegistry.get()
				.lookupGraphicsEnvironmentAdapter(graphicsContext.getGraphicsEnvironment());
		adapter.setBackgroundColorPaint(graphicsContext, this);
	}

	public void setColorValues(float[] paramColorValues) {
		colorValues = paramColorValues;
	}

	public void setForegroundPaintFromGraphicsContext(
			IGraphicsContext graphicsContext) {
		IGraphicsEnvironmentAdapter adapter = GraphicsEnvironmentAdapterRegistry.get()
				.lookupGraphicsEnvironmentAdapter(graphicsContext.getGraphicsEnvironment());
		adapter.setForegroundColorPaint(graphicsContext, this);
	}

}
