/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.image.awt;

import javax.imageio.metadata.IIOMetadata;

import de.intarsys.cwt.image.IImageEntry;
import de.intarsys.cwt.image.ImageContainer;
import de.intarsys.cwt.image.ImageMetadata;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.TransientLocator;

public class PDImageContainer extends ImageContainer {

	private PDImageEntry entry;

	private TransientLocator locator;

	private ImageMetadata metadata;

	public PDImageContainer(PDImage pdImage) {
		super();
		entry = new PDImageEntry(this, pdImage);
		locator = new TransientLocator("", "");
		metadata = new ImageMetadata(null,
				new IIOMetadata[] { new PDImageMetadata(pdImage) });
	}

	@Override
	protected void basicClose() {
		// nuttin here
	}

	public IImageEntry getImageAt(int index) {
		if (index != 0) {
			throw new IllegalArgumentException("invalid index");
		}
		return entry;
	}

	public int getImageCount() {
		return 1;
	}

	public ILocator getLocator() {
		return locator;
	}

	public ImageMetadata getMetadata() {
		return metadata;
	}

}
