/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.font.type3;

import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformFontFactory;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;

public class Type3FontFactory implements IPlatformFontFactory {

	private static final Attribute ATTR_PLATFORMFONT = new Attribute(
			"platformFont"); //$NON-NLS-1$

	static protected IPlatformFont lookupPlatformFont(IAttributeSupport as) {
		return (IPlatformFont) as.getAttribute(ATTR_PLATFORMFONT);
	}

	static protected void registerPlatformFont(IAttributeSupport as,
			IPlatformFont object) {
		as.setAttribute(ATTR_PLATFORMFONT, object);
	}

	protected IPlatformFont basicCreate(PDFont font) {
		return new Type3Font(font);
	}

	/*
	 * this is synchronized as two threads (e.g. viewing and printing) may race
	 * for the platform font.
	 * 
	 * @see de.intarsys.pdf.platform.common.IPlatformFontFactory#createPlatformFont(de.intarsys.pdf.font.PDFont)
	 */
	synchronized public IPlatformFont createPlatformFont(PDFont font)
			throws PlatformFontException {
		IPlatformFont result = lookupPlatformFont(font);
		if (result == null) {
			result = basicCreate(font);
			registerPlatformFont(font, result);
		}
		return result;
	}
}
