/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.font;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

import de.intarsys.cwt.font.afm.AFM;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptorEmbedded;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;

public class PDFontType1Tools {

	/**
	 * review this method - should not create from AFM
	 * 
	 * @param pdFont
	 * @return
	 * @throws FontFactoryException
	 */
	protected static PDFontDescriptorEmbedded createFontDescriptorEmbedded(
			PDFont pdFont) throws FontFactoryException {
		// create a new FontDescriptor based on the AFM of this font
		AFM afm = PDFontType1.lookupBuiltinAFM(pdFont.getFontName());
		PDFontDescriptorEmbedded result = (PDFontDescriptorEmbedded) PDFontDescriptorEmbedded.META
				.createNew();
		String fontBBox = null;
		String italicAngle = null;
		String ascent = null;
		String descend = null;
		String capheight = null;
		String stemV = null;
		boolean symbolic = false;
		if (afm != null) {
			fontBBox = afm.getAttribute("FontBBox");
			italicAngle = afm.getAttribute("ItalicAngle");
			ascent = afm.getAttribute("Ascender");
			descend = afm.getAttribute("Descender");
			capheight = afm.getAttribute("CapHeight");
			stemV = afm.getAttribute("StdHW");
			symbolic = afm.getAttribute("CharacterSet").equals("Special");
		}
		if (fontBBox == null) {
			fontBBox = "0 0 0 0";
		}
		if (italicAngle == null) {
			italicAngle = "0";
		}
		if (ascent == null) {
			ascent = "0";
		}
		if (descend == null) {
			descend = "0";
		}
		if (capheight == null) {
			capheight = "0";
		}
		if (stemV == null) {
			stemV = "0";
		}

		StringTokenizer tokens = new StringTokenizer(fontBBox);
		String a = tokens.nextToken();
		String b = tokens.nextToken();
		String c = tokens.nextToken();
		String d = tokens.nextToken();

		result.setFontName(pdFont.getFontName());
		result.setFontBB(new CDSRectangle(Integer.valueOf(a).intValue(),
				Integer.valueOf(b).intValue(), Integer.valueOf(c).intValue(),
				Integer.valueOf(d).intValue()));
		result.setItalicAngle(Float.valueOf(italicAngle).floatValue());
		result.setAscent(Integer.valueOf(ascent).intValue());
		result.setDescent(Integer.valueOf(descend).intValue());
		result.setCapHeight(Integer.valueOf(capheight).intValue());
		result.setStemV(Integer.valueOf(stemV).intValue());

		// Flags
		result.setFlags(0);
		result.getFlags().setSymbolic(symbolic);
		// widths

		try {
			int start = pdFont.getFirstChar();
			int stop = pdFont.getLastChar();
			COSArray fontWidths = COSArray.create(stop - start + 1);
			IPlatformFont pfFont = PlatformFontFactory.get()
					.createPlatformFont(pdFont);
			// todo
			for (int i = start; i <= stop; i++) {
				PDGlyphs pdglyphs = pdFont.getGlyphsEncoded(i);
				IPlatformGlyphs pfglyphs = pfFont
						.createPlatformGlyphs(pdglyphs);
				// todo glyphs
				fontWidths.add(i - start, COSInteger
						.create(pfglyphs.getWidth()));
			}
			pdFont.cosSetField(PDFont.DK_Widths, fontWidths);
			pdFont.cosSetField(PDFont.DK_FirstChar, COSInteger.create(start));
			pdFont.cosSetField(PDFont.DK_LastChar, COSInteger.create(stop));
		} catch (PlatformFontException e) {
			throw new FontFactoryException(e.getMessage());
		}

		// / pdFont.setFontDescriptor(result);
		return result;

	}

	static protected void embedFontFile(PDFont pdFont, ILocator locator)
			throws IOException {
		// this may be a builtin font - must do a little bit more to get it
		// embedded
		if (pdFont.getFontDescriptor().isBuiltin()) {
			try {
				pdFont.setFontDescriptor(createFontDescriptorEmbedded(pdFont));
			} catch (FontFactoryException e) {
				throw new IOException(e.getMessage());
			}
		}

		InputStream is = locator.getInputStream();
		try {
			byte[] data = StreamTools.toByteArray(is);
			((PDFontDescriptorEmbedded) pdFont.getFontDescriptor())
					.setFontFile(data);
		} finally {
			StreamTools.close(is);
		}
	}

}
