/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;

import de.intarsys.cwt.awt.image.CwtAwtImageTools;
import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;

/**
 * 
 */
public class AwtCSDeviceRGB extends AwtCSDevice {
	public AwtCSDeviceRGB(PDColorSpace pdColorSpace) {
		super(pdColorSpace);
	}

	@Override
	protected ColorSpace createColorSpace() {
		return ColorSpace.getInstance(ColorSpace.CS_sRGB);
	}

	@Override
	public ColorModel getColorModel(PDImage pdImage) {
		// reuse instance
		return CwtAwtImageTools.getRgbColorModel();
	}

	@Override
	public int getNumComponents() {
		return 3;
	}

	@Override
	public float[] getRGB(float[] values) {
		// adobe acrobat has been seen to create invalid color values for
		// widgets
		return new float[] { Math.max(Math.min(values[0], 1), 0),
				Math.max(Math.min(values[1], 1), 0),
				Math.max(Math.min(values[2], 1), 0) };
	}

	protected PDCSDeviceRGB myPDColorSpace() {
		return (PDCSDeviceRGB) getPDColorSpace();
	}
}
