/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDFunction;

public class PDInterpolationFunction
extends PDFunction {
    public static final COSName DK_C0 = COSName.constant("C0");
    public static final COSName DK_C1 = COSName.constant("C1");
    public static final COSName DK_N = COSName.constant("N");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private float[] c0;
    private float[] c1;
    private float n;

    protected PDInterpolationFunction(COSObject object) {
        super(object);
        int i;
        COSArray cosC0 = this.cosGetDict().get(DK_C0).asArray();
        if (cosC0 == null) {
            this.c0 = new float[]{0.0f};
        } else {
            this.c0 = new float[cosC0.size()];
            i = 0;
            while (i < this.c0.length) {
                this.c0[i] = cosC0.get(i).asNumber().floatValue();
                ++i;
            }
        }
        COSArray cosC1 = this.cosGetDict().get(DK_C1).asArray();
        if (cosC1 == null) {
            this.c1 = new float[]{1.0f};
        } else {
            this.c1 = new float[cosC1.size()];
            i = 0;
            while (i < this.c1.length) {
                this.c1[i] = cosC1.get(i).asNumber().floatValue();
                ++i;
            }
        }
        this.n = this.cosGetDict().get(DK_N).asNumber().floatValue();
    }

    protected float[] evaluate(float value) {
        if ((double)value == 0.0) {
            return this.getC0();
        }
        if ((double)value == 1.0) {
            return this.getC1();
        }
        float[] result = new float[this.getOutputSize()];
        int i = 0;
        while (i < result.length) {
            result[i] = (float)((double)this.c0[i] + Math.pow(value, this.n) * (double)(this.c1[i] - this.c0[i]));
            ++i;
        }
        return result;
    }

    public float[] evaluate(float[] values) {
        int outputSize = this.getOutputSize();
        float[] result = new float[values.length * outputSize];
        int i = 0;
        while (i < values.length) {
            System.arraycopy(this.evaluate(values[i]), i, result, i * outputSize, outputSize);
            ++i;
        }
        return result;
    }

    public float[] getC0() {
        return this.c0;
    }

    public float[] getC1() {
        return this.c1;
    }

    public float getN() {
        return this.n;
    }

    public int getOutputSize() {
        return this.getC0().length;
    }

    public static class MetaClass
    extends PDFunction.MetaClass {
        protected MetaClass(Class paramInstanceClass) {
            super(paramInstanceClass);
        }
    }
}

