/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.cwt.font.afm.AFM;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontType1;
import java.util.StringTokenizer;

public class PDFontDescriptorAFM
extends PDFontDescriptor {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private AFM afm;
    private int leading;
    private CDSRectangle bb;

    protected PDFontDescriptorAFM(AFM afm) {
        super(null);
        this.afm = afm;
    }

    public AFM getAfm() {
        return this.afm;
    }

    public float getAscent() {
        String value = this.getAfm().getAttribute("Ascender");
        if (value == null) {
            return 0.0f;
        }
        return Float.parseFloat(value);
    }

    public float getAvgWidth() {
        return 0.0f;
    }

    public float getCapHeight() {
        String value = this.getAfm().getAttribute("CapHeight");
        if (value == null) {
            return 0.0f;
        }
        return Float.parseFloat(value);
    }

    public String getCharSet() {
        return null;
    }

    public float getDescent() {
        String value = this.getAfm().getAttribute("Descender");
        if (value == null) {
            return 0.0f;
        }
        return Float.parseFloat(value);
    }

    public int getFlagsValue() {
        return 0;
    }

    public CDSRectangle getFontBB() {
        if (this.bb == null) {
            float llx = 0.0f;
            float lly = 0.0f;
            float urx = 0.0f;
            float ury = 0.0f;
            String value = this.getAfm().getAttribute("FontBBox");
            if (value != null) {
                StringTokenizer st = new StringTokenizer(value);
                if (st.hasMoreTokens()) {
                    llx = Float.parseFloat(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    lly = Float.parseFloat(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    urx = Float.parseFloat(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    ury = Float.parseFloat(st.nextToken());
                }
            }
            this.bb = new CDSRectangle(llx, lly, urx, ury);
        }
        return this.bb;
    }

    public String getFontFamily() {
        return null;
    }

    public String getFontName() {
        if (this.getAfm() == null) {
            return "";
        }
        String value = this.getAfm().getAttribute("FontName");
        if (value == null) {
            return "";
        }
        return value.trim();
    }

    public String getFontStretch() {
        return null;
    }

    public int getFontWeight() {
        return 0;
    }

    public float getItalicAngle() {
        String value = this.getAfm().getAttribute("ItalicAngle");
        if (value == null) {
            return 0.0f;
        }
        return Float.parseFloat(value);
    }

    public int getLeading() {
        if (this.leading == 0) {
            CDSRectangle rect = this.getFontBB();
            this.leading = (int)(rect.getUpperRightY() - rect.getLowerLeftY());
        }
        return this.leading;
    }

    public int getMaxWidth() {
        return 0;
    }

    public int getMissingWidth() {
        return 0;
    }

    public int getStemH() {
        String value = this.getAfm().getAttribute("StdHW");
        if (value == null) {
            return 0;
        }
        return (int)Float.parseFloat(value);
    }

    public int getStemV() {
        String value = this.getAfm().getAttribute("StdVW");
        if (value == null) {
            return 0;
        }
        return (int)Float.parseFloat(value);
    }

    public float getXHeight() {
        String value = this.getAfm().getAttribute("XHeight");
        if (value == null) {
            return 0.0f;
        }
        return Float.parseFloat(value);
    }

    public boolean isBuiltin() {
        return true;
    }

    public boolean isNonsymbolic() {
        return !this.isSymbolic();
    }

    public boolean isSymbolic() {
        String name = this.getFontName();
        return PDFontType1.FONT_ZapfDingbats.equals(name) || PDFontType1.FONT_Symbol.equals(name);
    }

    public void setCharSet(String charset) {
    }

    public void setFlagsValue(int value) {
    }

    public void setFontStretch(String stretch) {
    }

    public void setFontWeight(int weight) {
    }

    public static class MetaClass
    extends PDFontDescriptor.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            throw new IllegalStateException("can not instantiate PDFontDescriptorAFM as COSBasedObject");
        }
    }
}

