/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSInfoDict;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.string.StringTools;
import java.security.MessageDigest;
import java.util.Iterator;

public class COSTrailer
extends COSBasedObject {
    public static final COSName DK_Info = COSName.constant("Info");
    public static final COSName DK_Prev = COSName.constant("Prev");
    public static final COSName DK_Root = COSName.constant("Root");
    public static final COSName DK_Size = COSName.constant("Size");
    public static final COSName DK_Encrypt = COSName.constant("Encrypt");
    public static final COSName DK_ID = COSName.constant("ID");
    public static final COSName DK_XRefStm = COSName.constant("XRefStm");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private COSCatalog cachedCatalog;

    protected COSTrailer(COSObject object) {
        super(object);
    }

    public COSString cosGetDynamicFileID() {
        COSArray fileID = this.cosGetField(DK_ID).asArray();
        if (fileID == null || fileID.size() < 2) {
            return null;
        }
        return (COSString)fileID.get(1);
    }

    public COSDictionary cosGetEncryption() {
        return this.cosGetField(DK_Encrypt).asDictionary();
    }

    public COSArray cosGetFileID() {
        return this.cosGetField(DK_ID).asArray();
    }

    public COSArray cosGetID() {
        return this.cosGetField(DK_ID).asArray();
    }

    public COSString cosGetPermanentFileID() {
        COSArray fileID = this.cosGetField(DK_ID).asArray();
        if (fileID == null || fileID.size() == 0) {
            return null;
        }
        return (COSString)fileID.get(0);
    }

    public void cosSetEncryption(COSDictionary encryption) {
        this.cosSetField(DK_Encrypt, encryption);
    }

    protected byte[] createFileID() {
        ILocator locator;
        COSDocument cosDoc;
        block8: {
            block7: {
                cosDoc = this.cosGetDoc();
                if (cosDoc != null) break block7;
                return null;
            }
            locator = cosDoc.getLocator();
            if (locator != null) break block8;
            return null;
        }
        try {
            IRandomAccess ra = cosDoc.stGetDoc().getRandomAccess();
            if (ra == null) {
                ra = new RandomAccessByteArray(StringTools.toByteArray((String)"DummyValue"));
            }
            MessageDigest digest = MessageDigest.getInstance("MD5");
            long time = System.currentTimeMillis();
            digest.update(String.valueOf(time).getBytes());
            digest.update(locator.getFullName().getBytes());
            digest.update(String.valueOf(ra.getLength()).getBytes());
            COSInfoDict infoDict = this.getInfoDict();
            if (infoDict != null) {
                Iterator it = infoDict.cosGetDict().iterator();
                while (it.hasNext()) {
                    COSObject object = (COSObject)it.next();
                    digest.update(object.stringValue().getBytes());
                }
            }
            return digest.digest();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public COSInfoDict getInfoDict() {
        return (COSInfoDict)COSInfoDict.META.createFromCos(this.cosGetField(DK_Info).asDictionary());
    }

    public int getPrev() {
        return this.getFieldInt(DK_Prev, -1);
    }

    public COSCatalog getRoot() {
        if (this.cachedCatalog == null) {
            this.cachedCatalog = (COSCatalog)COSCatalog.META.createFromCos(this.cosGetField(DK_Root));
        }
        return this.cachedCatalog;
    }

    public int getSize() {
        return this.getFieldInt(DK_Size, -1);
    }

    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.setRoot((COSCatalog)COSCatalog.META.createNew());
        this.setInfoDict((COSInfoDict)COSInfoDict.META.createNew());
    }

    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedCatalog = null;
    }

    public void setInfoDict(COSInfoDict infoDict) {
        this.setFieldObject(DK_Info, infoDict);
    }

    public void setRoot(COSCatalog root) {
        this.setFieldObject(DK_Root, root);
    }

    public void updateFileID() {
        COSArray fileID = this.cosGetField(DK_ID).asArray();
        if (fileID == null || fileID.size() == 0) {
            fileID = COSArray.create();
            this.cosSetField(DK_ID, fileID);
            byte[] id = this.createFileID();
            COSString permanentID = COSString.create(id);
            fileID.add(permanentID);
            fileID.add(permanentID);
        } else {
            byte[] id = this.createFileID();
            COSString changingID = COSString.create(id);
            if (fileID.size() < 2) {
                fileID.add(changingID);
            } else {
                fileID.set(1, changingID);
            }
        }
    }

    public static class MetaClass
    extends COSBasedObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }
    }
}

