/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.filebuffer;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8435511960228370781L;
    private final Map<String, String> data;
    private final boolean sparse;

    public MetaData(Map<String, String> data) {
        this(data, false);
    }

    public MetaData(boolean sparse) {
        this(null, sparse);
    }

    public MetaData(Map<String, String> data, boolean sparse) {
        data = data == null ? Collections.emptyMap() : new HashMap<String, String>(data);
        this.data = data;
        this.sparse = sparse;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaData metaData = (MetaData)o;
        if (this.sparse != metaData.sparse) {
            return false;
        }
        return ((Object)this.data).equals(metaData.data);
    }

    public int hashCode() {
        return ((Object)this.data).hashCode();
    }

    public Map<String, String> getData() {
        return Collections.unmodifiableMap(this.data);
    }

    public String toString() {
        return "MetaData[sparse=" + this.sparse + ", data=" + this.data + "]";
    }

    public MetaData clone() throws CloneNotSupportedException {
        return (MetaData)super.clone();
    }
}

