/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.conditions;

import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.conditions.SearchStringCondition;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Message;
import java.io.Serializable;

public class NDCContainsCondition
implements LilithCondition,
SearchStringCondition {
    private static final long serialVersionUID = -3506546014592052304L;
    public static final String DESCRIPTION = "NDC.contains";
    private String searchString;

    public NDCContainsCondition() {
        this(null);
    }

    public NDCContainsCondition(String searchString) {
        this.searchString = searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public boolean isTrue(Object value) {
        EventWrapper wrapper;
        Serializable eventObj;
        if (this.searchString == null) {
            return false;
        }
        if (this.searchString.length() == 0) {
            return true;
        }
        if (value instanceof EventWrapper && (eventObj = (wrapper = (EventWrapper)value).getEvent()) instanceof LoggingEvent) {
            LoggingEvent event = (LoggingEvent)eventObj;
            Message[] messages = event.getNdc();
            if (messages == null || messages.length == 0) {
                return false;
            }
            for (Message current : messages) {
                if (!this.searchString.equals(current.getMessage())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NDCContainsCondition that = (NDCContainsCondition)o;
        return !(this.searchString == null ? that.searchString != null : !this.searchString.equals(that.searchString));
    }

    public int hashCode() {
        int result = this.searchString != null ? this.searchString.hashCode() : 0;
        return result;
    }

    public NDCContainsCondition clone() throws CloneNotSupportedException {
        return (NDCContainsCondition)super.clone();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDescription()).append("(");
        if (this.searchString != null) {
            result.append("\"");
            result.append(this.searchString);
            result.append("\"");
        } else {
            result.append("null");
        }
        result.append(")");
        return result.toString();
    }

    public String getDescription() {
        return DESCRIPTION;
    }
}

