/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.conditions;

import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import java.io.Serializable;
import java.util.Map;

public class MDCContainsCondition
implements LilithCondition {
    private static final long serialVersionUID = -7175187972553499074L;
    public static final String DESCRIPTION = "MDC.contains";
    private String key;
    private String value;

    public MDCContainsCondition() {
        this(null, null);
    }

    public MDCContainsCondition(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isTrue(Object element) {
        EventWrapper wrapper;
        Serializable eventObj;
        if (this.key == null) {
            return false;
        }
        if (element instanceof EventWrapper && (eventObj = (wrapper = (EventWrapper)element).getEvent()) instanceof LoggingEvent) {
            LoggingEvent event = (LoggingEvent)eventObj;
            Map mdc = event.getMdc();
            if (mdc == null || mdc.isEmpty()) {
                return false;
            }
            String actualValue = (String)mdc.get(this.key);
            return actualValue == this.value || this.value != null && this.value.equals(actualValue);
        }
        return false;
    }

    public MDCContainsCondition clone() throws CloneNotSupportedException {
        return (MDCContainsCondition)super.clone();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDescription()).append("(");
        if (this.key != null) {
            result.append("\"");
            result.append(this.key);
            result.append("\"");
        } else {
            result.append("null");
        }
        result.append(",");
        if (this.value != null) {
            result.append("\"");
            result.append(this.value);
            result.append("\"");
        } else {
            result.append("null");
        }
        result.append(")");
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MDCContainsCondition that = (MDCContainsCondition)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String getDescription() {
        return DESCRIPTION;
    }
}

