/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.conditions;

import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.conditions.SearchStringCondition;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class LoggerStartsWithCondition
implements LilithCondition,
SearchStringCondition {
    private static final long serialVersionUID = -9144937393832722541L;
    public static final String DESCRIPTION = "logger.startsWith";
    private String searchString;

    public LoggerStartsWithCondition() {
        this(null);
    }

    public LoggerStartsWithCondition(String searchString) {
        this.setSearchString(searchString);
    }

    public void setSearchString(String searchString) {
        if (searchString != null) {
            searchString = searchString.replace('$', '.');
        }
        this.searchString = searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public boolean isTrue(Object value) {
        EventWrapper wrapper;
        Serializable eventObj;
        if (this.searchString == null) {
            return false;
        }
        if (this.searchString.length() == 0) {
            return true;
        }
        if (value instanceof EventWrapper && (eventObj = (wrapper = (EventWrapper)value).getEvent()) instanceof LoggingEvent) {
            LoggingEvent event = (LoggingEvent)eventObj;
            String logger = event.getLogger();
            if (logger == null) {
                return false;
            }
            logger = logger.replace('$', '.');
            return logger.startsWith(this.searchString);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoggerStartsWithCondition that = (LoggerStartsWithCondition)o;
        return !(this.searchString == null ? that.searchString != null : !this.searchString.equals(that.searchString));
    }

    public int hashCode() {
        int result = this.searchString != null ? this.searchString.hashCode() : 0;
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setSearchString(this.searchString);
    }

    public LoggerStartsWithCondition clone() throws CloneNotSupportedException {
        return (LoggerStartsWithCondition)super.clone();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDescription()).append("(");
        if (this.searchString != null) {
            result.append("\"");
            result.append(this.searchString);
            result.append("\"");
        } else {
            result.append("null");
        }
        result.append(")");
        return result.toString();
    }

    public String getDescription() {
        return DESCRIPTION;
    }
}

