/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.conditions;

import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.conditions.SearchStringCondition;
import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class HttpStatusCodeCondition
implements LilithCondition,
SearchStringCondition {
    private static final long serialVersionUID = -3335718950761221210L;
    public static final String DESCRIPTION = "HttpStatusCode==";
    private String searchString;
    private transient int code;

    public HttpStatusCodeCondition() {
        this(null);
    }

    public HttpStatusCodeCondition(String searchString) {
        this.setSearchString(searchString);
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
        try {
            this.code = Integer.parseInt(searchString);
        }
        catch (Throwable e) {
            this.code = 0;
        }
    }

    public String getSearchString() {
        return this.searchString;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public boolean isTrue(Object value) {
        EventWrapper wrapper;
        Serializable eventObj;
        if (this.searchString == null) {
            return false;
        }
        if (this.searchString.length() == 0) {
            return true;
        }
        if (value instanceof EventWrapper && (eventObj = (wrapper = (EventWrapper)value).getEvent()) instanceof AccessEvent) {
            AccessEvent event = (AccessEvent)eventObj;
            return event.getStatusCode() == this.code;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpStatusCodeCondition that = (HttpStatusCodeCondition)o;
        return this.code == that.code;
    }

    public int hashCode() {
        return this.code;
    }

    public HttpStatusCodeCondition clone() throws CloneNotSupportedException {
        HttpStatusCodeCondition result = (HttpStatusCodeCondition)super.clone();
        result.setSearchString(this.searchString);
        return result;
    }

    private Object readResolve() throws ObjectStreamException {
        this.setSearchString(this.searchString);
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDescription());
        result.append(this.code);
        return result.toString();
    }
}

