/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.conditions;

import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.conditions.SearchStringCondition;
import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import java.io.Serializable;

public class HttpRemoteUserCondition
implements LilithCondition,
SearchStringCondition {
    private static final long serialVersionUID = -6203602189173332391L;
    public static final String DESCRIPTION = "HttpRemoteUser==";
    private static final String NA = "-";
    private String searchString;

    public HttpRemoteUserCondition() {
        this(null);
    }

    public HttpRemoteUserCondition(String searchString) {
        this.searchString = searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public boolean isTrue(Object value) {
        EventWrapper wrapper;
        Serializable eventObj;
        if (this.searchString == null) {
            return false;
        }
        if (this.searchString.length() == 0) {
            return true;
        }
        if (value instanceof EventWrapper && (eventObj = (wrapper = (EventWrapper)value).getEvent()) instanceof AccessEvent) {
            AccessEvent event = (AccessEvent)eventObj;
            String remoteUser = event.getRemoteUser();
            if (NA.equals(remoteUser)) {
                remoteUser = null;
            }
            return this.searchString.equals(remoteUser);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRemoteUserCondition that = (HttpRemoteUserCondition)o;
        return !(this.searchString != null ? !this.searchString.equals(that.searchString) : that.searchString != null);
    }

    public int hashCode() {
        return this.searchString != null ? this.searchString.hashCode() : 0;
    }

    public HttpRemoteUserCondition clone() throws CloneNotSupportedException {
        return (HttpRemoteUserCondition)super.clone();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDescription());
        result.append(this.searchString);
        return result.toString();
    }
}

