/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.conditions;

import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.conditions.SearchStringCondition;
import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import java.io.Serializable;

public class HttpMethodCondition
implements LilithCondition,
SearchStringCondition {
    private static final long serialVersionUID = -7228665790197479145L;
    public static final String DESCRIPTION = "HttpMethod==";
    private String searchString;

    public HttpMethodCondition() {
        this(null);
    }

    public HttpMethodCondition(String searchString) {
        this.searchString = searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public boolean isTrue(Object value) {
        EventWrapper wrapper;
        Serializable eventObj;
        if (this.searchString == null) {
            return false;
        }
        if (this.searchString.length() == 0) {
            return true;
        }
        if (value instanceof EventWrapper && (eventObj = (wrapper = (EventWrapper)value).getEvent()) instanceof AccessEvent) {
            AccessEvent event = (AccessEvent)eventObj;
            return this.searchString.equals(event.getMethod());
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpMethodCondition that = (HttpMethodCondition)o;
        return !(this.searchString != null ? !this.searchString.equals(that.searchString) : that.searchString != null);
    }

    public int hashCode() {
        return this.searchString != null ? this.searchString.hashCode() : 0;
    }

    public HttpMethodCondition clone() throws CloneNotSupportedException {
        return (HttpMethodCondition)super.clone();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDescription());
        result.append(this.searchString);
        return result.toString();
    }
}

