/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.conditions;

import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.conditions.SearchStringCondition;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.groovy.GroovyInstance;
import groovy.lang.Binding;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyCondition
implements LilithCondition,
SearchStringCondition {
    private static final long serialVersionUID = 907179107764473874L;
    private final Logger logger = LoggerFactory.getLogger(GroovyCondition.class);
    private String scriptFileName;
    private String searchString;
    private transient String scriptName;
    private transient GroovyInstance groovyInstance;

    public GroovyCondition() {
        this(null);
    }

    public GroovyCondition(String scriptFileName) {
        this.setScriptFileName(scriptFileName);
    }

    public GroovyCondition(String scriptFileName, String searchString) {
        this.setScriptFileName(scriptFileName);
        this.setSearchString(searchString);
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public void setScriptFileName(String scriptFileName) {
        if (this.groovyInstance == null) {
            this.groovyInstance = new GroovyInstance();
        }
        this.scriptFileName = scriptFileName;
        this.groovyInstance.setGroovyFileName(scriptFileName);
        if (scriptFileName != null) {
            File scriptFile = new File(scriptFileName);
            this.scriptName = scriptFile.getName();
        }
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    public boolean isTrue(Object o) {
        Object instance = this.groovyInstance.getInstance();
        if (instance == null) {
            if (this.logger.isWarnEnabled()) {
                String message = "Couldn't retrieve condition! " + this.groovyInstance.getErrorMessage();
                Throwable cause = this.groovyInstance.getErrorCause();
                if (cause != null) {
                    this.logger.warn(message, cause);
                } else {
                    this.logger.warn(message);
                }
            }
            return false;
        }
        try {
            if (instance instanceof Condition) {
                Condition condition = (Condition)instance;
                return condition.isTrue(o);
            }
            if (instance instanceof Script) {
                Script script = (Script)instance;
                Binding binding = new Binding();
                binding.setVariable("input", o);
                if (this.searchString != null) {
                    binding.setVariable("searchString", (Object)this.searchString);
                }
                binding.setVariable("logger", (Object)this.logger);
                script.setBinding(binding);
                Object result = script.run();
                return result != null && !result.equals(Boolean.FALSE);
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Expected either Condition or Script but got {} instead!", (Object)instance.getClass().getName());
            }
            return false;
        }
        catch (Throwable t) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while executing '{}'!", (Object)this.scriptFileName, (Object)t);
            }
            return false;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setScriptFileName(this.scriptFileName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroovyCondition)) {
            return false;
        }
        GroovyCondition that = (GroovyCondition)o;
        if (this.scriptFileName != null ? !this.scriptFileName.equals(that.scriptFileName) : that.scriptFileName != null) {
            return false;
        }
        return !(this.searchString != null ? !this.searchString.equals(that.searchString) : that.searchString != null);
    }

    public int hashCode() {
        int result = this.scriptFileName != null ? this.scriptFileName.hashCode() : 0;
        result = 31 * result + (this.searchString != null ? this.searchString.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDescription());
        if (this.searchString != null) {
            result.append("(");
            result.append(this.searchString);
            result.append(")");
        }
        return result.toString();
    }

    public GroovyCondition clone() throws CloneNotSupportedException {
        GroovyCondition result = (GroovyCondition)super.clone();
        result.setScriptFileName(result.scriptFileName);
        return result;
    }

    public String getDescription() {
        return this.scriptName;
    }
}

