/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.ExtractedFileSets;
import de.flapdoodle.embed.process.extract.Extractors;
import de.flapdoodle.embed.process.extract.FilesToExtract;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.extract.IExtractor;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.store.IArtifactStore;
import de.flapdoodle.embed.process.store.IDownloader;
import de.flapdoodle.embed.process.store.LocalArtifactStore;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactStore
implements IArtifactStore {
    private static Logger logger = LoggerFactory.getLogger(ArtifactStore.class);
    private final IDownloadConfig _downloadConfig;
    private final IDirectory _tempDirFactory;
    private final ITempNaming _executableNaming;
    private final IDownloader _downloader;

    public ArtifactStore(IDownloadConfig downloadConfig, IDirectory tempDirFactory, ITempNaming executableNaming, IDownloader downloader) {
        this._downloadConfig = downloadConfig;
        this._tempDirFactory = tempDirFactory;
        this._executableNaming = executableNaming;
        this._downloader = downloader;
    }

    public ArtifactStore with(IDirectory tempDirFactory, ITempNaming executableNaming) {
        return new ArtifactStore(this._downloadConfig, tempDirFactory, executableNaming, this._downloader);
    }

    @Override
    public boolean checkDistribution(Distribution distribution) throws IOException {
        if (!LocalArtifactStore.checkArtifact(this._downloadConfig, distribution)) {
            return LocalArtifactStore.store(this._downloadConfig, distribution, this._downloader.download(this._downloadConfig, distribution));
        }
        return true;
    }

    @Override
    public IExtractedFileSet extractFileSet(Distribution distribution) throws IOException {
        IPackageResolver packageResolver = this._downloadConfig.getPackageResolver();
        FilesToExtract toExtract = this.filesToExtract(distribution);
        IExtractor extractor = Extractors.getExtractor(packageResolver.getArchiveType(distribution));
        File artifact = LocalArtifactStore.getArtifact(this._downloadConfig, distribution);
        IExtractedFileSet extracted = extractor.extract(this._downloadConfig, artifact, toExtract);
        return extracted;
    }

    FilesToExtract filesToExtract(Distribution distribution) {
        return new FilesToExtract(this._tempDirFactory, this._executableNaming, this._downloadConfig.getPackageResolver().getFileSet(distribution));
    }

    @Override
    public void removeFileSet(Distribution distribution, IExtractedFileSet all) {
        ExtractedFileSets.delete(all);
    }
}

