/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.PathSummary;
import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import com.webcohesion.enunciate.metadata.Label;
import com.webcohesion.enunciate.metadata.rs.ResourceLabel;
import com.webcohesion.enunciate.modules.spring_web.api.impl.PathSummaryImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ResourceImpl;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import com.webcohesion.enunciate.modules.spring_web.model.SpringController;
import com.webcohesion.enunciate.util.PathSummaryComparator;
import com.webcohesion.enunciate.util.ResourceComparator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class ResourceClassResourceGroupImpl
implements ResourceGroup {
    private final SpringController controllerClass;
    private final List<Resource> resources = new ArrayList<Resource>();
    private final String contextPath;
    private final String slug;
    private final ApiRegistrationContext registrationContext;

    public ResourceClassResourceGroupImpl(SpringController controllerClass, String slug, String contextPath, ApiRegistrationContext registrationContext) {
        this.controllerClass = controllerClass;
        this.slug = slug;
        this.contextPath = contextPath;
        FacetFilter facetFilter = registrationContext.getFacetFilter();
        for (RequestMapping requestMapping : controllerClass.getRequestMappings()) {
            if (!facetFilter.accept((HasFacets)requestMapping)) continue;
            this.resources.add(new ResourceImpl(requestMapping, this, registrationContext));
        }
        Collections.sort(this.resources, new ResourceComparator(controllerClass.getContext().getPathSortStrategy()));
        this.registrationContext = registrationContext;
    }

    public String getSlug() {
        return "resource_" + this.slug;
    }

    public String getLabel() {
        JavaDoc.JavaDocTagList tags;
        Label generic;
        String label = this.controllerClass.getSimpleName().toString();
        ResourceLabel resourceLabel = (ResourceLabel)this.controllerClass.getAnnotation(ResourceLabel.class);
        if (resourceLabel != null && !"##default".equals(resourceLabel.value())) {
            label = resourceLabel.value();
        }
        if ((generic = (Label)this.controllerClass.getAnnotation(Label.class)) != null) {
            label = generic.value();
        }
        if ((tags = (JavaDoc.JavaDocTagList)this.controllerClass.getJavaDoc().get((Object)"label")) != null && tags.size() > 0) {
            String tag = ((String)tags.get(0)).trim();
            label = tag.isEmpty() ? label : tag;
        }
        return label;
    }

    public String getSortKey() {
        String sortKey = this.getLabel();
        ResourceLabel resourceLabel = (ResourceLabel)this.controllerClass.getAnnotation(ResourceLabel.class);
        if (resourceLabel != null && !"##default".equals(resourceLabel.sortKey())) {
            sortKey = resourceLabel.sortKey();
        }
        return sortKey;
    }

    public String getRelativeContextPath() {
        return this.contextPath;
    }

    public String getDescription() {
        return this.controllerClass.getJavaDoc(this.registrationContext.getTagHandler()).toString();
    }

    public String getDeprecated() {
        return ElementUtils.findDeprecationMessage((DecoratedElement)this.controllerClass, (JavaDocTagHandler)this.registrationContext.getTagHandler());
    }

    public List<PathSummary> getPaths() {
        HashMap<String, PathSummary> summaries = new HashMap<String, PathSummary>();
        for (Resource resource : this.resources) {
            TreeSet<String> methods = new TreeSet<String>();
            for (Method method : resource.getMethods()) {
                methods.add(method.getHttpMethod());
            }
            PathSummary summary = (PathSummary)summaries.get(resource.getPath());
            if (summary == null) {
                summary = new PathSummaryImpl(resource.getPath(), methods, resource.getStyles());
                summaries.put(resource.getPath(), summary);
                continue;
            }
            summary.getMethods().addAll(methods);
        }
        ArrayList<PathSummary> pathSummaries = new ArrayList<PathSummary>(summaries.values());
        Collections.sort(pathSummaries, new PathSummaryComparator(this.controllerClass.getContext().getPathSortStrategy()));
        return pathSummaries;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.controllerClass.getAnnotation(annotationType);
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.controllerClass.getAnnotations();
    }

    public Set<Facet> getFacets() {
        return this.controllerClass.getFacets();
    }

    public JavaDoc getJavaDoc() {
        return this.controllerClass.getJavaDoc(this.registrationContext.getTagHandler());
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.controllerClass), (Map)this.controllerClass.getContext().getContext().getConfiguration().getAnnotationStyles());
    }
}

