/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web;

import com.webcohesion.enunciate.CompletionFailureException;
import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.ApiRegistry;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicProviderModule;
import com.webcohesion.enunciate.module.DependencySpec;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.module.MediaTypeDefinitionModule;
import com.webcohesion.enunciate.module.TypeDetectingModule;
import com.webcohesion.enunciate.modules.spring_web.EnunciateSpringWebContext;
import com.webcohesion.enunciate.modules.spring_web.SpringWebApiRegistry;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceRepresentationMetadata;
import com.webcohesion.enunciate.modules.spring_web.model.ResponseCode;
import com.webcohesion.enunciate.modules.spring_web.model.SpringController;
import com.webcohesion.enunciate.modules.spring_web.model.SpringControllerAdvice;
import com.webcohesion.enunciate.util.AnnotationUtils;
import com.webcohesion.enunciate.util.PathSortStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.reflections.adapters.MetadataAdapter;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RestController;

public class SpringWebModule
extends BasicProviderModule
implements TypeDetectingModule,
ApiRegistryProviderModule,
ApiFeatureProviderModule {
    private ApiRegistryProviderModule.DataTypeDetectionStrategy defaultDataTypeDetectionStrategy;
    private final List<MediaTypeDefinitionModule> mediaTypeModules = new ArrayList<MediaTypeDefinitionModule>();
    private EnunciateSpringWebContext springContext;
    static final String NAME = "spring-web";
    private PathSortStrategy defaultSortStrategy = PathSortStrategy.breadth_first;

    public String getName() {
        return NAME;
    }

    public List<DependencySpec> getDependencySpecifications() {
        return Collections.singletonList(new MediaTypeDependencySpec());
    }

    public ApiRegistryProviderModule.DataTypeDetectionStrategy getDataTypeDetectionStrategy() {
        String dataTypeDetection = this.config.getString("[@datatype-detection]", null);
        if (dataTypeDetection != null) {
            try {
                return ApiRegistryProviderModule.DataTypeDetectionStrategy.valueOf((String)dataTypeDetection);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.defaultDataTypeDetectionStrategy != null) {
            return this.defaultDataTypeDetectionStrategy;
        }
        if (this.enunciate.getIncludePatterns().isEmpty()) {
            return ApiRegistryProviderModule.DataTypeDetectionStrategy.local;
        }
        return ApiRegistryProviderModule.DataTypeDetectionStrategy.aggressive;
    }

    public void setDefaultDataTypeDetectionStrategy(ApiRegistryProviderModule.DataTypeDetectionStrategy strategy) {
        this.defaultDataTypeDetectionStrategy = strategy;
    }

    public PathSortStrategy getPathSortStrategy() {
        PathSortStrategy strategy = this.defaultSortStrategy;
        try {
            strategy = PathSortStrategy.valueOf((String)this.config.getString("[@path-sort-strategy]", this.defaultSortStrategy.name()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return strategy;
    }

    public boolean isDisableExamples() {
        return this.config.getBoolean("[@disableExamples]", false);
    }

    public void setDefaultSortStrategy(PathSortStrategy defaultSortStrategy) {
        this.defaultSortStrategy = defaultSortStrategy;
    }

    public EnunciateSpringWebContext getSpringWebContext() {
        return this.springContext;
    }

    public ApiRegistry getApiRegistry() {
        return new SpringWebApiRegistry(this.springContext);
    }

    public void call(EnunciateContext context) {
        this.springContext = new EnunciateSpringWebContext(context, this.isDisableExamples());
        ApiRegistryProviderModule.DataTypeDetectionStrategy detectionStrategy = this.getDataTypeDetectionStrategy();
        if (detectionStrategy != ApiRegistryProviderModule.DataTypeDetectionStrategy.passive) {
            Set elements = detectionStrategy == ApiRegistryProviderModule.DataTypeDetectionStrategy.local ? context.getLocalApiElements() : context.getApiElements();
            for (Element declaration : elements) {
                try {
                    if (!(declaration instanceof TypeElement)) continue;
                    TypeElement element = (TypeElement)declaration;
                    Controller controllerInfo = (Controller)AnnotationUtils.getMetaAnnotation(Controller.class, (Element)declaration);
                    if (controllerInfo == null && AnnotationUtils.getMetaAnnotation(ControllerAdvice.class, (Element)declaration) == null) continue;
                    this.springContext.add(new SpringControllerAdvice(element, this.springContext));
                }
                catch (RuntimeException e) {
                    if (e.getClass().getName().endsWith("CompletionFailure")) {
                        throw new CompletionFailureException(Collections.singletonList(declaration), (Throwable)e);
                    }
                    throw e;
                }
            }
            for (Element declaration : elements) {
                LinkedList<Element> contextStack = new LinkedList<Element>();
                contextStack.push(declaration);
                try {
                    SpringController springController;
                    List<RequestMapping> requestMappings;
                    if (!(declaration instanceof TypeElement)) continue;
                    TypeElement element = (TypeElement)declaration;
                    Controller controllerInfo = (Controller)AnnotationUtils.getMetaAnnotation(Controller.class, (Element)declaration);
                    if (controllerInfo == null || (requestMappings = (springController = new SpringController(element, this.springContext)).getRequestMappings()).isEmpty()) continue;
                    this.springContext.add(springController);
                    for (RequestMapping requestMapping : requestMappings) {
                        this.addReferencedDataTypeDefinitions(requestMapping, contextStack);
                    }
                }
                catch (RuntimeException e) {
                    if (e.getClass().getName().endsWith("CompletionFailure")) {
                        throw new CompletionFailureException(contextStack, (Throwable)e);
                    }
                    throw e;
                }
                finally {
                    contextStack.pop();
                }
            }
        }
        String relativeContextPath = this.config.getString("application[@path]", "");
        while (relativeContextPath.startsWith("/")) {
            relativeContextPath = relativeContextPath.substring(1);
        }
        while (relativeContextPath.endsWith("/")) {
            relativeContextPath = relativeContextPath.substring(0, relativeContextPath.length() - 1);
        }
        this.springContext.setRelativeContextPath(relativeContextPath);
        this.springContext.setGroupingStrategy(this.getGroupingStrategy());
        this.springContext.setPathSortStrategy(this.getPathSortStrategy());
    }

    protected void addReferencedDataTypeDefinitions(RequestMapping requestMapping, LinkedList<Element> contextStack) {
        List<? extends ResponseCode> statusCodes;
        ResourceRepresentationMetadata outputPayload;
        TypeMirror type;
        ResourceEntityParameter ep = requestMapping.getEntityParameter();
        if (ep != null) {
            Set<String> consumes = requestMapping.getConsumesMediaTypes();
            contextStack.push(ep.getDelegate());
            type = ep.getType();
            contextStack.push((Element)((Object)requestMapping));
            try {
                for (MediaTypeDefinitionModule mediaTypeDefinitionModule : this.mediaTypeModules) {
                    mediaTypeDefinitionModule.addDataTypeDefinitions(type, consumes, contextStack);
                }
            }
            catch (RuntimeException e) {
                if (e.getClass().getName().endsWith("CompletionFailure")) {
                    throw new CompletionFailureException(contextStack, (Throwable)e);
                }
                throw e;
            }
            finally {
                contextStack.pop();
            }
        }
        if ((outputPayload = requestMapping.getRepresentationMetadata()) != null) {
            type = outputPayload.getDelegate();
            Set<String> produces = requestMapping.getProducesMediaTypes();
            contextStack.push((Element)((Object)requestMapping));
            try {
                for (MediaTypeDefinitionModule mediaTypeModule : this.mediaTypeModules) {
                    mediaTypeModule.addDataTypeDefinitions(type, produces, contextStack);
                }
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException.getClass().getName().endsWith("CompletionFailure")) {
                    throw new CompletionFailureException(contextStack, (Throwable)runtimeException);
                }
                throw runtimeException;
            }
            finally {
                contextStack.pop();
            }
        }
        if ((statusCodes = requestMapping.getStatusCodes()) != null) {
            for (ResponseCode responseCode : statusCodes) {
                DecoratedTypeMirror type2 = responseCode.getType();
                if (type2 == null) continue;
                Set<String> produces = requestMapping.getProducesMediaTypes();
                contextStack.push((Element)((Object)requestMapping));
                try {
                    for (MediaTypeDefinitionModule mediaTypeModule : this.mediaTypeModules) {
                        mediaTypeModule.addDataTypeDefinitions((TypeMirror)type2, produces, contextStack);
                    }
                }
                catch (RuntimeException e) {
                    if (e.getClass().getName().endsWith("CompletionFailure")) {
                        throw new CompletionFailureException(contextStack, (Throwable)e);
                    }
                    throw e;
                }
                finally {
                    contextStack.pop();
                }
            }
        }
    }

    public EnunciateSpringWebContext.GroupingStrategy getGroupingStrategy() {
        String groupBy = this.config.getString("[@groupBy]", "class");
        if ("class".equals(groupBy)) {
            return EnunciateSpringWebContext.GroupingStrategy.resource_class;
        }
        if ("path".equals(groupBy)) {
            return EnunciateSpringWebContext.GroupingStrategy.path;
        }
        if ("annotation".equals(groupBy)) {
            return EnunciateSpringWebContext.GroupingStrategy.annotation;
        }
        throw new EnunciateException("Unknown grouping strategy: " + groupBy);
    }

    public boolean internal(Object type, MetadataAdapter metadata) {
        String classname = metadata.getClassName(type);
        return classname.startsWith("org.springframework");
    }

    public boolean typeDetected(Object type, MetadataAdapter metadata) {
        List classAnnotations = metadata.getClassAnnotationNames(type);
        if (classAnnotations != null) {
            for (String classAnnotation : classAnnotations) {
                if (!Controller.class.getName().equals(classAnnotation) && !RestController.class.getName().equals(classAnnotation)) continue;
                return true;
            }
        }
        return false;
    }

    public class MediaTypeDependencySpec
    implements DependencySpec {
        public boolean accept(EnunciateModule module) {
            if (module instanceof MediaTypeDefinitionModule) {
                MediaTypeDefinitionModule definitionModule = (MediaTypeDefinitionModule)module;
                SpringWebModule.this.mediaTypeModules.add(definitionModule);
                definitionModule.setDefaultDataTypeDetectionStrategy(ApiRegistryProviderModule.DataTypeDetectionStrategy.passive);
                return true;
            }
            return false;
        }

        public boolean isFulfilled() {
            return true;
        }

        public String toString() {
            return "media type definition modules";
        }
    }
}

