/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws.model;

import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessage;
import com.webcohesion.enunciate.modules.jaxws.model.WebMessagePart;
import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import com.webcohesion.enunciate.modules.jaxws.model.WebParam;
import java.util.ArrayList;
import java.util.Collection;
import javax.jws.soap.SOAPBinding;
import javax.lang.model.type.TypeKind;

public class RPCOutputMessage
implements WebMessage {
    private final WebMethod webMethod;

    public RPCOutputMessage(WebMethod webMethod) {
        this.webMethod = webMethod;
        if (webMethod.getSoapBindingStyle() != SOAPBinding.Style.RPC) {
            throw new IllegalArgumentException("An RPC-style output message cannot be created from a web method of DOCUMENT-style");
        }
    }

    public String getOperationName() {
        return this.webMethod.getOperationName();
    }

    public String getTargetNamespace() {
        return this.webMethod.getDeclaringEndpointInterface().getTargetNamespace();
    }

    public String getResponseBeanName() {
        String capitalizedName = this.webMethod.getSimpleName().toString();
        capitalizedName = Character.toString(capitalizedName.charAt(0)).toUpperCase() + capitalizedName.substring(1);
        return this.webMethod.getDeclaringEndpointInterface().getPackage().getQualifiedName() + ".jaxws." + capitalizedName + "Response";
    }

    @Override
    public String getMessageName() {
        return this.webMethod.getDeclaringEndpointInterface().getSimpleName() + "." + this.webMethod.getSimpleName() + "Response";
    }

    @Override
    public String getMessageDocs() {
        String docs = "Output message for operation \"" + this.webMethod.getOperationName() + "\".";
        String methodDocs = this.webMethod.getJavaDoc().toString();
        if (methodDocs.trim().length() > 0) {
            docs = docs + " (" + methodDocs.trim() + ")";
        }
        return docs;
    }

    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return true;
    }

    @Override
    public boolean isHeader() {
        return false;
    }

    @Override
    public boolean isFault() {
        return false;
    }

    @Override
    public Collection<WebMessagePart> getParts() {
        ArrayList<WebMessagePart> parts = new ArrayList<WebMessagePart>();
        for (WebParam webParam : this.webMethod.getWebParameters()) {
            if (!webParam.isOutput() || webParam.isHeader()) continue;
            parts.add(webParam);
        }
        DecoratedTypeMirror returnType = this.webMethod.getReturnType();
        if (returnType.getKind() != TypeKind.VOID) {
            parts.add(this.webMethod.getWebResult());
        }
        return parts;
    }
}

