/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.decorations.type;

import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.ElementDecorator;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecoration;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.javac.javadoc.DefaultJavaDocTagHandler;
import com.webcohesion.enunciate.javac.javadoc.DocComment;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;

public class DecoratedTypeMirror<T extends TypeMirror>
implements TypeMirror {
    protected final T delegate;
    protected final DecoratedProcessingEnvironment env;
    private DocComment docComment;
    private List<AnnotationMirror> annotationMirrors;

    public DecoratedTypeMirror(T delegate, DecoratedProcessingEnvironment env) {
        while (delegate instanceof DecoratedTypeMirror) {
            delegate = ((DecoratedTypeMirror)delegate).delegate;
        }
        this.delegate = delegate;
        this.env = env;
        if (this.env.getTypeMirrorDecorations() != null) {
            for (TypeMirrorDecoration decoration : this.env.getTypeMirrorDecorations()) {
                decoration.applyTo(this);
            }
        }
    }

    @Override
    public TypeKind getKind() {
        return this.delegate.getKind();
    }

    @Override
    public <R, P> R accept(TypeVisitor<R, P> v, P p) {
        return this.delegate.accept(v, p);
    }

    @Override
    public List<? extends AnnotationMirror> getAnnotationMirrors() {
        if (this.annotationMirrors == null) {
            this.annotationMirrors = ElementDecorator.decorateAnnotationMirrors(this.delegate.getAnnotationMirrors(), this.env);
        }
        return this.annotationMirrors;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.delegate.getAnnotation(annotationType);
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        return this.delegate.getAnnotationsByType(annotationType);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DecoratedTypeMirror) {
            return this.equals(((DecoratedTypeMirror)obj).delegate);
        }
        return this.delegate.equals(obj);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    public boolean isInstanceOf(Class<?> clazz) {
        return this.isInstanceOf(TypeMirrorUtils.mirrorOf(clazz, (ProcessingEnvironment)this.env));
    }

    public boolean isInstanceOf(String typeName) {
        return this.isInstanceOf(TypeMirrorUtils.mirrorOf(typeName, this.env));
    }

    public boolean isInstanceOf(Element type) {
        return type != null && this.isInstanceOf(type.asType());
    }

    public boolean isInstanceOf(TypeMirror candidate) {
        return candidate != null && this.getKind() != TypeKind.EXECUTABLE && this.getKind() != TypeKind.PACKAGE && candidate.getKind() != TypeKind.EXECUTABLE && candidate.getKind() != TypeKind.PACKAGE && this.env.getTypeUtils().isAssignable((TypeMirror)this.delegate, candidate);
    }

    public boolean isAnnotation() {
        return this.isDeclared() && ((DeclaredType)this.delegate).asElement().getKind() == ElementKind.ANNOTATION_TYPE;
    }

    public boolean isArray() {
        return this.getKind() == TypeKind.ARRAY;
    }

    public boolean isCollection() {
        return this.isInstanceOf(TypeMirrorUtils.collectionTypeErasure(this.env));
    }

    public boolean isList() {
        return this.isInstanceOf(TypeMirrorUtils.listTypeErasure(this.env));
    }

    public boolean isNull() {
        return this.getKind() == TypeKind.NULL;
    }

    public boolean isReferenceType() {
        return false;
    }

    public boolean isClass() {
        return this.isDeclared() && ((DeclaredType)this.delegate).asElement().getKind() == ElementKind.CLASS;
    }

    public boolean isDeclared() {
        return this.getKind() == TypeKind.DECLARED;
    }

    public boolean isEnum() {
        return this.isDeclared() && ((DeclaredType)this.delegate).asElement().getKind() == ElementKind.ENUM;
    }

    public boolean isInterface() {
        return this.isDeclared() && ((DeclaredType)this.delegate).asElement().getKind() == ElementKind.INTERFACE;
    }

    public boolean isPrimitive() {
        return this.getKind().isPrimitive();
    }

    public boolean isTypeVariable() {
        return this.getKind() == TypeKind.TYPEVAR;
    }

    public boolean isVoid() {
        return this.getKind() == TypeKind.VOID;
    }

    public boolean isWildcard() {
        return this.getKind() == TypeKind.WILDCARD;
    }

    public T getDelegate() {
        return this.delegate;
    }

    public String getDocComment() {
        return this.getDocComment(DefaultJavaDocTagHandler.INSTANCE);
    }

    public DocComment getDeferredDocComment() {
        return this.docComment;
    }

    public void setDeferredDocComment(DocComment docComment) {
        this.docComment = docComment;
    }

    private String getDocComment(JavaDocTagHandler tagHandler) {
        return this.docComment == null ? "" : this.docComment.get(tagHandler);
    }

    public String getDocValue() {
        return this.getDocValue(DefaultJavaDocTagHandler.INSTANCE);
    }

    public String getDocValue(JavaDocTagHandler tagHandler) {
        String value = this.getDocComment(tagHandler);
        if (value != null && "".equals(value = value.trim())) {
            value = null;
        }
        return value;
    }
}

