/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.spring.SpringInstantiator;
import com.vaadin.flow.spring.SpringVaadinSession;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class SpringVaadinServletService
extends VaadinServletService {
    private final transient ApplicationContext context;
    static final String SPRING_BOOT_WEBPROPERTIES_CLASS = "org.springframework.boot.autoconfigure.web.WebProperties";

    public SpringVaadinServletService(VaadinServlet servlet, DeploymentConfiguration deploymentConfiguration, ApplicationContext context) {
        super(servlet, deploymentConfiguration);
        this.context = context;
    }

    protected Optional<Instantiator> loadInstantiators() throws ServiceException {
        Optional spiInstantiator = super.loadInstantiators();
        List springInstantiators = this.context.getBeansOfType(Instantiator.class).values().stream().collect(Collectors.toList());
        if (spiInstantiator.isPresent() && !springInstantiators.isEmpty()) {
            throw new ServiceException("Cannot init VaadinService because there are multiple eligible instantiator implementations: Java SPI registered instantiator " + spiInstantiator.get() + " and Spring instantiator beans: " + springInstantiators);
        }
        if (!spiInstantiator.isPresent() && springInstantiators.isEmpty()) {
            SpringInstantiator defaultInstantiator = new SpringInstantiator((VaadinService)this, this.context);
            return Optional.of(defaultInstantiator);
        }
        return spiInstantiator.isPresent() ? spiInstantiator : springInstantiators.stream().findFirst();
    }

    public void init() throws ServiceException {
        super.init();
        Map uiInitListeners = this.context.getBeansOfType(UIInitListener.class);
        uiInitListeners.values().forEach(arg_0 -> ((SpringVaadinServletService)this).addUIInitListener(arg_0));
    }

    protected VaadinSession createVaadinSession(VaadinRequest request) {
        return new SpringVaadinSession((VaadinService)this);
    }

    public URL getStaticResource(String path) {
        URL resource = super.getStaticResource(path);
        if (resource == null) {
            resource = this.getResourceURL(path);
        }
        return resource;
    }

    private URL getResourceURL(String path) {
        if (!this.isSpringBootConfigured()) {
            return null;
        }
        for (String prefix : ((WebProperties)this.context.getBean(WebProperties.class)).getResources().getStaticLocations()) {
            Resource resource = this.context.getResource(this.getFullPath(path, prefix));
            if (resource == null || !resource.exists()) continue;
            try {
                URI uri = resource.getURI();
                if (uri.isOpaque() && resource.isFile()) {
                    return resource.getFile().getAbsoluteFile().toURI().toURL();
                }
                return resource.getURL();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getFullPath(String path, String prefix) {
        if (prefix.endsWith("/") && path.startsWith("/")) {
            return prefix + path.substring(1);
        }
        return prefix + path;
    }

    private boolean isSpringBootConfigured() {
        Class<?> resourcesClass = SpringVaadinServletService.resolveClass(SPRING_BOOT_WEBPROPERTIES_CLASS);
        if (resourcesClass != null) {
            return this.context.getBeanNamesForType(resourcesClass).length != 0;
        }
        return false;
    }

    private static Class<?> resolveClass(String clazzName) {
        try {
            return Class.forName(clazzName, false, SpringVaadinServletService.class.getClassLoader());
        }
        catch (ClassNotFoundException | LinkageError e) {
            return null;
        }
    }
}

