/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl.provider.entity;

import com.sun.jersey.core.util.FeaturesAndProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.ObjectMapper;

public class JacksonProviderProxy
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    JacksonJsonProvider jacksonProvider = new JacksonJsonProvider();
    boolean jacksonEntityProviderFeatureSet = false;

    @Context
    public void setFeaturesAndProperties(FeaturesAndProperties fp) {
        this.jacksonEntityProviderFeatureSet = fp.getFeature("com.sun.jersey.api.json.POJOMappingFeature");
    }

    @Context
    public void setProviders(Providers p) {
        ContextResolver omResolver = p.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE);
        if (omResolver != null) {
            this.jacksonProvider.setMapper((ObjectMapper)omResolver.getContext(ObjectMapper.class));
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.jacksonEntityProviderFeatureSet && this.jacksonProvider.isReadable(type, genericType, annotations, mediaType);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return this.jacksonProvider.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.jacksonEntityProviderFeatureSet && this.jacksonProvider.isWriteable(type, genericType, annotations, mediaType);
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.jacksonProvider.getSize(t, type, genericType, annotations, mediaType);
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.jacksonProvider.writeTo(t, type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }
}

