/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.client;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.oauth.client.RequestWrapper;
import com.sun.jersey.oauth.client.UnauthorizedRequestException;
import com.sun.jersey.oauth.signature.OAuthParameters;
import com.sun.jersey.oauth.signature.OAuthRequest;
import com.sun.jersey.oauth.signature.OAuthSecrets;
import com.sun.jersey.oauth.signature.OAuthSignature;
import com.sun.jersey.oauth.signature.OAuthSignatureException;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Providers;

public final class OAuthClientFilter
extends ClientFilter {
    private final Providers providers;
    private final OAuthParameters parameters;
    private final OAuthSecrets secrets;
    private final URI requestTokenUri;
    private final URI accessTokenUri;
    private final URI authorizationUri;
    private final AuthHandler handler;
    private State state;

    public OAuthClientFilter(Providers providers, OAuthParameters parameters, OAuthSecrets secrets) {
        this(providers, parameters, secrets, null, null, null, null);
    }

    public OAuthClientFilter(Providers providers, OAuthParameters parameters, OAuthSecrets secrets, String requestTokenUri, String accessTokenUri, String authorizationUri, AuthHandler handler) {
        if (providers == null || parameters == null || secrets == null) {
            throw new NullPointerException();
        }
        if (!(requestTokenUri == null && accessTokenUri == null && authorizationUri == null || requestTokenUri != null && accessTokenUri != null && authorizationUri != null)) {
            throw new NullPointerException();
        }
        this.providers = providers;
        this.parameters = parameters;
        this.secrets = secrets;
        AuthHandler authHandler = this.handler = handler == null ? new AuthHandler(){

            @Override
            public void authorized(String token, String tokenSecret) {
            }

            @Override
            public String authorize(URI authorizationUri) {
                return null;
            }
        } : handler;
        if (parameters.getSignatureMethod() == null) {
            parameters.signatureMethod("HMAC-SHA1");
        }
        if (parameters.getVersion() == null) {
            parameters.version();
        }
        if (requestTokenUri == null) {
            this.authorizationUri = null;
            this.accessTokenUri = null;
            this.requestTokenUri = null;
            this.state = State.UNMANAGED;
        } else {
            this.requestTokenUri = UriBuilder.fromUri((String)requestTokenUri).build(new Object[0]);
            this.accessTokenUri = UriBuilder.fromUri((String)accessTokenUri).build(new Object[0]);
            this.authorizationUri = UriBuilder.fromUri((String)authorizationUri).build(new Object[0]);
            this.state = State.MANAGED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        block26: {
            if (request.getHeaders().containsKey((Object)"Authorization")) break block26;
            switch (2.$SwitchMap$com$sun$jersey$oauth$client$OAuthClientFilter$State[this.state.ordinal()]) {
                case 1: {
                    if (this.parameters.getToken() != null) break;
                    this.state = State.UNMANAGED;
                    try {
                        cr = this.handle(ClientRequest.create().build(this.requestTokenUri, "POST"));
                        if (cr.getStatus() >= 400) {
                            var3_4 = cr;
                            return var3_4;
                        }
                        response = (Form)cr.getEntity(Form.class);
                        token = response.getFirst("oauth_token");
                        this.parameters.token(token);
                        this.secrets.tokenSecret(response.getFirst("oauth_token_secret"));
                        this.state = State.REQUEST_TOKEN;
                        this.parameters.verifier(this.handler.authorize(this.getAuthorizationUri()));
                        var5_12 = this.handle(request);
                        return var5_12;
                    }
                    finally {
                        if (this.state == State.UNMANAGED) {
                            this.parameters.token(null);
                            this.secrets.tokenSecret(null);
                        }
                        if (this.state != State.REQUEST_TOKEN) {
                            this.state = State.MANAGED;
                        }
                    }
                }
                case 2: {
                    if (this.parameters.getVerifier() == null) {
                        throw new UnauthorizedRequestException(this.parameters, this.getAuthorizationUri());
                    }
                    this.state = State.UNMANAGED;
                    try {
                        cr = this.handle(ClientRequest.create().build(this.accessTokenUri, "POST"));
                        if (cr.getStatus() < 400) ** GOTO lbl59
                        response = cr;
                    }
                    catch (Throwable var7_15) {
                        this.parameters.remove((Object)"oauth_verifier");
                        if (this.state == State.UNMANAGED) {
                            this.parameters.token(null);
                            this.secrets.tokenSecret(null);
                            this.state = State.MANAGED;
                        }
                        throw var7_15;
                    }
                    this.parameters.remove((Object)"oauth_verifier");
                    if (this.state == State.UNMANAGED) {
                        this.parameters.token(null);
                        this.secrets.tokenSecret(null);
                        this.state = State.MANAGED;
                    }
                    return response;
lbl59:
                    // 2 sources

                    response = (Form)cr.getEntity(Form.class);
                    token = response.getFirst("oauth_token");
                    secret = response.getFirst("oauth_token_secret");
                    if (token == null) {
                        throw new UnauthorizedRequestException(this.parameters, null);
                    }
                    this.parameters.token(token);
                    this.secrets.tokenSecret(secret);
                    this.handler.authorized(this.parameters.getToken(), this.secrets.getTokenSecret());
                    this.state = State.MANAGED;
                    this.parameters.remove((Object)"oauth_verifier");
                    if (this.state != State.UNMANAGED) break;
                    this.parameters.token(null);
                    this.secrets.tokenSecret(null);
                    this.state = State.MANAGED;
                    break;
                }
            }
            p = (OAuthParameters)this.parameters.clone();
            if (p.getTimestamp() == null) {
                p.setTimestamp();
            }
            if (p.getNonce() == null) {
                p.setNonce();
            }
            try {
                OAuthSignature.sign((OAuthRequest)new RequestWrapper(request, this.providers), (OAuthParameters)p, (OAuthSecrets)this.secrets);
            }
            catch (OAuthSignatureException se) {
                throw new ClientHandlerException((Throwable)se);
            }
        }
        uie = null;
        try {
            response = this.getNext().handle(request);
        }
        catch (UniformInterfaceException e) {
            response = e.getResponse();
            uie = e;
        }
        if (this.state == State.MANAGED && response.getClientResponseStatus() == ClientResponse.Status.UNAUTHORIZED) {
            request.getHeaders().remove((Object)"Authorization");
            this.parameters.token(null);
            this.secrets.tokenSecret(null);
            uie = null;
            return this.handle(request);
        }
        if (uie != null) {
            throw uie;
        }
        return response;
    }

    private URI getAuthorizationUri() {
        return UriBuilder.fromUri((URI)this.authorizationUri).queryParam("oauth_token", new Object[]{this.parameters.getToken()}).build(new Object[0]);
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$com$sun$jersey$oauth$client$OAuthClientFilter$State;

        static {
            $SwitchMap$com$sun$jersey$oauth$client$OAuthClientFilter$State = new int[State.values().length];
            try {
                2.$SwitchMap$com$sun$jersey$oauth$client$OAuthClientFilter$State[State.MANAGED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$sun$jersey$oauth$client$OAuthClientFilter$State[State.REQUEST_TOKEN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static interface AuthHandler {
        public String authorize(URI var1);

        public void authorized(String var1, String var2);
    }

    private static enum State {
        UNMANAGED,
        MANAGED,
        REQUEST_TOKEN;

    }
}

