/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.standalonemojos;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.simpligility.maven.plugins.android.AbstractAndroidMojo;
import com.simpligility.maven.plugins.android.DeviceCallback;
import com.simpligility.maven.plugins.android.common.DeviceHelper;
import com.simpligility.maven.plugins.android.config.ConfigHandler;
import com.simpligility.maven.plugins.android.config.ConfigPojo;
import com.simpligility.maven.plugins.android.config.PullParameter;
import com.simpligility.maven.plugins.android.configuration.Run;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Mojo(name="run")
public class RunMojo
extends AbstractAndroidMojo {
    @ConfigPojo
    @Parameter
    private Run run;
    @Parameter(property="android.run.debug")
    protected String runDebug;
    @PullParameter(defaultValue={"false"})
    private String parsedDebug;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("apk")) {
            try {
                LauncherInfo launcherInfo = this.getLauncherActivity();
                ConfigHandler configHandler = new ConfigHandler((Object)this, this.session, this.execution);
                configHandler.parseConfiguration();
                this.launch(launcherInfo);
            }
            catch (Exception ex) {
                this.getLog().info((CharSequence)"Unable to run launcher Activity");
                this.getLog().debug((Throwable)ex);
            }
        } else {
            this.getLog().info((CharSequence)"Project packaging is not apk, skipping run action.");
        }
    }

    private LauncherInfo getLauncherActivity() throws ParserConfigurationException, SAXException, IOException, XPathExpressionException, MojoFailureException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(this.destinationManifestFile);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = xPath.compile("//manifest/application/activity/intent-filter[action[@name=\"android.intent.action.MAIN\"] and category[@name=\"android.intent.category.LAUNCHER\"]]/..");
        Object result = xPathExpression.evaluate(document, XPathConstants.NODESET);
        if (result instanceof NodeList) {
            NodeList activities = (NodeList)result;
            if (activities.getLength() > 0) {
                LauncherInfo launcherInfo = new LauncherInfo();
                String activityName = activities.item(0).getAttributes().getNamedItem("android:name").getNodeValue();
                if (!activityName.contains(".")) {
                    activityName = "." + activityName;
                }
                if (activityName.startsWith(".")) {
                    String packageName = document.getElementsByTagName("manifest").item(0).getAttributes().getNamedItem("package").getNodeValue();
                    activityName = packageName + activityName;
                }
                launcherInfo.activity = activityName;
                launcherInfo.packageName = this.renameManifestPackage != null ? this.renameManifestPackage : document.getDocumentElement().getAttribute("package").toString();
                return launcherInfo;
            }
            throw new MojoFailureException("Could not find a launcher activity in manifest");
        }
        throw new MojoFailureException("Could not find any activity in manifest");
    }

    private void launch(final LauncherInfo info) throws MojoExecutionException, MojoFailureException {
        final int debugPort = this.findDebugPort();
        final String command = String.format("am start %s-n %s/%s", debugPort >= 0 ? "-D " : "", info.packageName, info.activity);
        this.doWithDevices(new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException, MojoFailureException {
                block10: {
                    String deviceLogLinePrefix = DeviceHelper.getDeviceLogLinePrefix(device);
                    try {
                        String line;
                        RunMojo.this.getLog().info((CharSequence)(deviceLogLinePrefix + "Attempting to start " + info.packageName + "/" + info.activity));
                        CollectingOutputReceiver shellOutput = new CollectingOutputReceiver();
                        device.executeShellCommand(command, (IShellOutputReceiver)shellOutput);
                        if (shellOutput.getOutput().contains("Error")) {
                            throw new MojoFailureException(shellOutput.getOutput());
                        }
                        if (debugPort <= 0) break block10;
                        CollectingOutputReceiver processOutput = new CollectingOutputReceiver();
                        device.executeShellCommand("ps", (IShellOutputReceiver)processOutput);
                        BufferedReader r = new BufferedReader(new StringReader(processOutput.getOutput()));
                        int pid = -1;
                        while ((line = r.readLine()) != null) {
                            String[] values;
                            if (!line.endsWith(info.packageName) || (values = line.split(" +")).length <= 2) continue;
                            pid = Integer.valueOf(values[1]);
                            break;
                        }
                        r.close();
                        if (pid == -1) {
                            throw new MojoFailureException("Cannot find stated process " + info.packageName);
                        }
                        RunMojo.this.getLog().info((CharSequence)(deviceLogLinePrefix + "Process " + debugPort + " launched"));
                        try {
                            RunMojo.createForward(device, debugPort, pid);
                            RunMojo.this.getLog().info((CharSequence)(deviceLogLinePrefix + "Debugger listening on " + debugPort));
                        }
                        catch (Exception ex) {
                            throw new MojoFailureException("Cannot create forward tcp: " + debugPort + " jdwp: " + pid, (Throwable)ex);
                        }
                    }
                    catch (IOException ex) {
                        throw new MojoFailureException(deviceLogLinePrefix + "Input/Output error", (Throwable)ex);
                    }
                    catch (TimeoutException ex) {
                        throw new MojoFailureException(deviceLogLinePrefix + "Command timeout", (Throwable)ex);
                    }
                    catch (AdbCommandRejectedException ex) {
                        throw new MojoFailureException(deviceLogLinePrefix + "ADB rejected the command", (Throwable)ex);
                    }
                    catch (ShellCommandUnresponsiveException ex) {
                        throw new MojoFailureException(deviceLogLinePrefix + "Unresponsive command", (Throwable)ex);
                    }
                }
            }
        });
    }

    private static void createForward(IDevice device, int debugPort, int pid) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m = Class.forName("com.android.ddmlib.AdbHelper").getDeclaredMethod("createForward", InetSocketAddress.class, device.getClass(), String.class, String.class);
        m.setAccessible(true);
        m.invoke(null, AndroidDebugBridge.getSocketAddress(), device, String.format("tcp:%d", debugPort), String.format("jdwp:%d", pid));
    }

    private int findDebugPort() {
        int debugPort;
        if ("true".equals(this.parsedDebug)) {
            debugPort = 0;
        } else {
            try {
                debugPort = Integer.parseInt(this.parsedDebug);
            }
            catch (NumberFormatException ex) {
                debugPort = -1;
            }
        }
        return debugPort;
    }

    private static class LauncherInfo {
        private String packageName;
        private String activity;

        private LauncherInfo() {
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getActivity() {
            return this.activity;
        }

        public void setActivity(String activity) {
            this.activity = activity;
        }
    }
}

