/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.common;

import com.google.common.io.PatternFilenameFilter;
import com.simpligility.maven.plugins.android.AbstractAndroidMojo;
import com.simpligility.maven.plugins.android.AndroidNdk;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.OrArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class NativeHelper {
    public static final int NDK_REQUIRED_VERSION = 7;
    private MavenProject project;
    private DependencyGraphBuilder dependencyGraphBuilder;
    private Log log;

    public NativeHelper(MavenProject project, DependencyGraphBuilder dependencyGraphBuilder, Log log) {
        this.project = project;
        this.dependencyGraphBuilder = dependencyGraphBuilder;
        this.log = log;
    }

    public static boolean hasStaticNativeLibraryArtifact(Set<Artifact> resolveNativeLibraryArtifacts, File unpackDirectory, String ndkArchitecture) {
        for (Artifact resolveNativeLibraryArtifact : resolveNativeLibraryArtifacts) {
            File[] aFiles;
            if ("a".equals(resolveNativeLibraryArtifact.getType())) {
                return true;
            }
            if (!"apklib".equals(resolveNativeLibraryArtifact.getType()) || (aFiles = NativeHelper.listNativeFiles(resolveNativeLibraryArtifact, unpackDirectory, ndkArchitecture, true)) == null || aFiles.length <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSharedNativeLibraryArtifact(Set<Artifact> resolveNativeLibraryArtifacts, File unpackDirectory, String ndkArchitecture) {
        for (Artifact resolveNativeLibraryArtifact : resolveNativeLibraryArtifacts) {
            File[] soFiles;
            if ("so".equals(resolveNativeLibraryArtifact.getType())) {
                return true;
            }
            if (!"apklib".equals(resolveNativeLibraryArtifact.getType()) || (soFiles = NativeHelper.listNativeFiles(resolveNativeLibraryArtifact, unpackDirectory, ndkArchitecture, false)) == null || soFiles.length <= 0) continue;
            return true;
        }
        return false;
    }

    public static File[] listNativeFiles(Artifact a, File unpackDirectory, String ndkArchitecture, final boolean staticLibrary) {
        File libsFolder = new File(AbstractAndroidMojo.getLibraryUnpackDirectory(unpackDirectory, a), "libs" + File.separator + ndkArchitecture);
        if (libsFolder.exists()) {
            return libsFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("lib") && name.endsWith(staticLibrary ? ".a" : ".so");
                }
            });
        }
        return null;
    }

    public Set<Artifact> getNativeDependenciesArtifacts(AbstractAndroidMojo mojo, File unpackDirectory, boolean sharedLibraries) throws MojoExecutionException {
        this.log.debug((CharSequence)("Finding native dependencies. UnpackFolder=" + unpackDirectory + " shared=" + sharedLibraries));
        LinkedHashSet<Artifact> filteredArtifacts = new LinkedHashSet<Artifact>();
        LinkedHashSet allArtifacts = new LinkedHashSet();
        allArtifacts.addAll(this.project.getDependencyArtifacts());
        allArtifacts.addAll(this.project.getArtifacts());
        for (Artifact artifact : allArtifacts) {
            boolean isNativeLibrary = this.isNativeLibrary(sharedLibraries, artifact.getType());
            this.log.debug((CharSequence)("Checking artifact : " + artifact));
            if (isNativeLibrary && artifact.getScope() == null) {
                this.log.debug((CharSequence)("Including attached artifact: " + artifact + ". Artifact scope is not set."));
                filteredArtifacts.add(artifact);
                continue;
            }
            if (isNativeLibrary && ("compile".equals(artifact.getScope()) || "runtime".equals(artifact.getScope()))) {
                this.log.debug((CharSequence)("Including attached artifact: " + artifact + ". Artifact scope is Compile or Runtime."));
                filteredArtifacts.add(artifact);
                continue;
            }
            String type = artifact.getType();
            if ("apklib".equals(type) || "aar".equals(type)) {
                File libsFolder = mojo != null ? mojo.getUnpackedLibNativesFolder(artifact) : new File(AbstractAndroidMojo.getLibraryUnpackDirectory(unpackDirectory, artifact), "aar".equals(type) ? "jni" : "libs");
                if (!libsFolder.exists()) {
                    this.log.debug((CharSequence)("Skipping " + libsFolder.getAbsolutePath() + " for native artifacts"));
                    continue;
                }
                if (!libsFolder.isDirectory()) continue;
                this.log.debug((CharSequence)("Checking " + libsFolder.getAbsolutePath() + " for native artifacts"));
                if (libsFolder.list((FilenameFilter)new PatternFilenameFilter("^.*(?<!(?i)\\.jar)$")).length <= 0) continue;
                this.log.debug((CharSequence)("Including attached artifact: " + artifact + ". Artifact is " + artifact.getType()));
                filteredArtifacts.add(artifact);
                continue;
            }
            if ("jar".equals(type)) continue;
            this.log.debug((CharSequence)("Not checking " + type + " for native artifacts"));
        }
        Set<Artifact> transitiveArtifacts = this.processTransitiveDependencies(this.project.getDependencies(), sharedLibraries);
        filteredArtifacts.addAll(transitiveArtifacts);
        return filteredArtifacts;
    }

    private boolean isNativeLibrary(boolean sharedLibraries, String artifactType) {
        return sharedLibraries ? "so".equals(artifactType) : "a".equals(artifactType);
    }

    private Set<Artifact> processTransitiveDependencies(List<Dependency> dependencies, boolean sharedLibraries) throws MojoExecutionException {
        LinkedHashSet<Artifact> transitiveArtifacts = new LinkedHashSet<Artifact>();
        for (Dependency dependency : dependencies) {
            if ("provided".equals(dependency.getScope()) || dependency.isOptional()) continue;
            Set<Artifact> transArtifactsFor = this.processTransitiveDependencies(dependency, sharedLibraries);
            this.log.debug((CharSequence)("Found transitive dependencies for : " + dependency + " transDeps : " + transArtifactsFor));
            transitiveArtifacts.addAll(transArtifactsFor);
        }
        return transitiveArtifacts;
    }

    private Set<Artifact> processTransitiveDependencies(Dependency dependency, boolean sharedLibraries) throws MojoExecutionException {
        try {
            LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
            ArrayList<String> exclusionPatterns = new ArrayList<String>();
            if (dependency.getExclusions() != null && !dependency.getExclusions().isEmpty()) {
                for (Exclusion exclusion : dependency.getExclusions()) {
                    exclusionPatterns.add(exclusion.getGroupId() + ":" + exclusion.getArtifactId());
                }
            }
            ArtifactFilter optionalFilter = new ArtifactFilter(){

                public boolean include(Artifact artifact) {
                    return !artifact.isOptional();
                }
            };
            AndArtifactFilter filter = new AndArtifactFilter();
            filter.add((ArtifactFilter)new ExcludesArtifactFilter(exclusionPatterns));
            filter.add((ArtifactFilter)new OrArtifactFilter(Arrays.asList(new ScopeArtifactFilter("compile"), new ScopeArtifactFilter("runtime"), new ScopeArtifactFilter("test"))));
            filter.add(optionalFilter);
            DependencyNode node = this.dependencyGraphBuilder.buildDependencyGraph(this.project, (ArtifactFilter)filter);
            CollectingDependencyNodeVisitor collectingVisitor = new CollectingDependencyNodeVisitor();
            node.accept((DependencyNodeVisitor)collectingVisitor);
            List dependencies = collectingVisitor.getNodes();
            for (DependencyNode dep : dependencies) {
                boolean isNativeLibrary = this.isNativeLibrary(sharedLibraries, dep.getArtifact().getType());
                if (!isNativeLibrary) continue;
                artifacts.add(dep.getArtifact());
            }
            return artifacts;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while processing transitive dependencies", e);
        }
    }

    public static void validateNDKVersion(File ndkHomeDir) throws MojoExecutionException {
        File ndkVersionFile = new File(ndkHomeDir, "RELEASE.TXT");
        if (!ndkVersionFile.exists()) {
            throw new MojoExecutionException("Could not locate RELEASE.TXT in the Android NDK base directory '" + ndkHomeDir.getAbsolutePath() + "'.  Please verify your setup! " + "Please provide a proper Android NDK directory path as configuration parameter <ndk><path>...</path></ndk> in the plugin <configuration/>. As an alternative, you may add the parameter to commandline: -Dandroid.ndk.path=... or set environment variable ANDROID_NDK_HOME.");
        }
        try {
            String versionStr = FileUtils.readFileToString((File)ndkVersionFile);
            NativeHelper.validateNDKVersion(7, versionStr);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while extracting NDK version from '" + ndkVersionFile.getAbsolutePath() + "'. Please verify your setup! " + "Please provide a proper Android NDK directory path as configuration parameter <ndk><path>...</path></ndk> in the plugin <configuration/>. As an alternative, you may add the parameter to commandline: -Dandroid.ndk.path=... or set environment variable ANDROID_NDK_HOME.");
        }
    }

    public static void validateNDKVersion(int desiredVersion, String versionStr) throws MojoExecutionException {
        int version = 0;
        if (versionStr != null) {
            versionStr = versionStr.trim();
            Pattern pattern = Pattern.compile("[r]([0-9]{1,3})([a-z]{0,1}).*");
            Matcher m = pattern.matcher(versionStr);
            if (m.matches()) {
                String group = m.group(1);
                version = Integer.parseInt(group);
            }
        }
        if (version < desiredVersion) {
            throw new MojoExecutionException("You are running an old NDK (version " + versionStr + "), please update " + "to at least r'" + desiredVersion + "' or later");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAppAbi(File applicationMakefile) {
        block8: {
            Scanner scanner = null;
            try {
                if (applicationMakefile == null || !applicationMakefile.exists()) break block8;
                scanner = new Scanner(applicationMakefile);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (!line.startsWith("APP_ABI")) continue;
                    String[] stringArray = line.substring(line.indexOf(":=") + 2).trim().split(" ");
                    return stringArray;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        return null;
    }

    public static String extractArchitectureFromArtifact(Artifact artifact, String defaultArchitecture) {
        String classifier = artifact.getClassifier();
        if (classifier != null) {
            for (int i = AndroidNdk.NDK_ARCHITECTURES.length - 1; i >= 0; --i) {
                String ndkArchitecture = AndroidNdk.NDK_ARCHITECTURES[i];
                if (!classifier.startsWith(ndkArchitecture)) continue;
                return ndkArchitecture;
            }
        }
        return defaultArchitecture;
    }

    public static String[] getNdkArchitectures(String ndkArchitectures, String applicationMakefile, File basedir) throws MojoExecutionException {
        String[] foundNdkArchitectures;
        File appMK;
        if (ndkArchitectures != null) {
            return ndkArchitectures.split(" ");
        }
        String applicationMakefileToUse = applicationMakefile;
        if (applicationMakefileToUse == null) {
            applicationMakefileToUse = "jni/Application.mk";
        }
        if ((appMK = new File(basedir, applicationMakefileToUse)).exists() && (foundNdkArchitectures = NativeHelper.getAppAbi(appMK)) != null) {
            return foundNdkArchitectures;
        }
        return new String[]{"armeabi"};
    }

    public static boolean artifactHasHardwareArchitecture(Artifact artifact, String ndkArchitecture, String defaultArchitecture) {
        return "so".equals(artifact.getType()) && ndkArchitecture.equals(NativeHelper.extractArchitectureFromArtifact(artifact, defaultArchitecture));
    }
}

