/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.JavaWriter;
import com.mysema.codegen.ScalaWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.querydsl.codegen.AbstractModule;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.QueryTypeFactory;
import com.querydsl.codegen.Serializer;
import com.querydsl.codegen.SimpleSerializerConfig;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.sql.ColumnImpl;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.SQLTemplatesRegistry;
import com.querydsl.sql.SchemaAndTable;
import com.querydsl.sql.codegen.KeyDataFactory;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.SQLCodegenModule;
import com.querydsl.sql.codegen.SpatialSupport;
import com.querydsl.sql.codegen.support.ForeignKeyData;
import com.querydsl.sql.codegen.support.InverseForeignKeyData;
import com.querydsl.sql.codegen.support.NotNullImpl;
import com.querydsl.sql.codegen.support.PrimaryKeyData;
import com.querydsl.sql.codegen.support.SizeImpl;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataExporter {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataExporter.class);
    private final SQLTemplatesRegistry sqlTemplatesRegistry = new SQLTemplatesRegistry();
    private final SQLCodegenModule module = new SQLCodegenModule();
    private final Set<String> classes = new HashSet<String>();
    private File targetFolder;
    private File beansTargetFolder;
    @Nullable
    private String beanPackageName;
    @Nullable
    private String schemaPattern;
    @Nullable
    private String tableNamePattern;
    @Nullable
    private Serializer beanSerializer;
    private boolean createScalaSources = false;
    private final Map<EntityType, Type> entityToWrapped = new HashMap<EntityType, Type>();
    private Serializer serializer;
    private TypeMappings typeMappings;
    private QueryTypeFactory queryTypeFactory;
    private NamingStrategy namingStrategy;
    private Configuration configuration;
    private KeyDataFactory keyDataFactory;
    private boolean columnAnnotations = false;
    private boolean validationAnnotations = false;
    private boolean schemaToPackage = false;
    private String sourceEncoding = "UTF-8";
    private boolean lowerCase = false;
    private boolean exportTables = true;
    private boolean exportViews = true;
    private boolean exportAll = false;
    private boolean exportPrimaryKeys = true;
    private boolean exportForeignKeys = true;
    private boolean exportDirectForeignKeys = true;
    private boolean exportInverseForeignKeys = true;
    private boolean spatial = false;
    @Nullable
    private String tableTypesToExport;

    protected EntityType createEntityType(SchemaAndTable schemaAndTable, String className) {
        EntityType classModel;
        if (this.beanSerializer == null) {
            String packageName = this.normalizePackage(this.module.getPackageName(), schemaAndTable);
            String simpleName = this.module.getPrefix() + className + this.module.getSuffix();
            SimpleType classTypeModel = new SimpleType(TypeCategory.ENTITY, packageName + "." + simpleName, packageName, simpleName, false, false, new Type[0]);
            classModel = new EntityType((Type)classTypeModel, (Function)this.module.get(Function.class, "variableNameFunction"));
            this.typeMappings.register((Type)classModel, (Type)classModel);
        } else {
            String beanPackage = this.normalizePackage(this.beanPackageName, schemaAndTable);
            String simpleName = this.module.getBeanPrefix() + className + this.module.getBeanSuffix();
            SimpleType classTypeModel = new SimpleType(TypeCategory.ENTITY, beanPackage + "." + simpleName, beanPackage, simpleName, false, false, new Type[0]);
            classModel = new EntityType((Type)classTypeModel, (Function)this.module.get(Function.class, "variableNameFunction"));
            Type mappedType = this.queryTypeFactory.create((Type)classModel);
            this.entityToWrapped.put(classModel, mappedType);
            this.typeMappings.register((Type)classModel, mappedType);
        }
        classModel.getData().put("schema", schemaAndTable.getSchema());
        classModel.getData().put("table", schemaAndTable.getTable());
        return classModel;
    }

    private String normalizePackage(String packageName, SchemaAndTable schemaAndTable) {
        String rval = packageName;
        if (this.schemaToPackage) {
            rval = this.namingStrategy.getPackage(rval, schemaAndTable);
        }
        return rval;
    }

    protected Property createProperty(EntityType classModel, String normalizedColumnName, String propertyName, Type typeModel) {
        return new Property(classModel, propertyName, propertyName, typeModel, Collections.emptyList(), false);
    }

    public void export(DatabaseMetaData md) throws SQLException {
        ArrayList<String> types;
        if (this.beanPackageName == null) {
            this.beanPackageName = this.module.getPackageName();
        }
        if (this.beansTargetFolder == null) {
            this.beansTargetFolder = this.targetFolder;
        }
        this.module.bind("beanPackageName", this.beanPackageName);
        if (this.spatial) {
            SpatialSupport.addSupport((AbstractModule)this.module);
        }
        this.classes.clear();
        this.typeMappings = (TypeMappings)this.module.get(TypeMappings.class);
        this.queryTypeFactory = (QueryTypeFactory)this.module.get(QueryTypeFactory.class);
        this.serializer = (Serializer)this.module.get(Serializer.class);
        this.beanSerializer = (Serializer)this.module.get(Serializer.class, "beanSerializer");
        this.namingStrategy = (NamingStrategy)this.module.get(NamingStrategy.class);
        this.configuration = (Configuration)this.module.get(Configuration.class);
        SQLTemplates templates = this.sqlTemplatesRegistry.getTemplates(md);
        if (templates != null) {
            this.configuration.setTemplates(templates);
        } else {
            logger.info("Found no specific dialect for " + md.getDatabaseProductName());
        }
        this.keyDataFactory = this.beanSerializer == null ? new KeyDataFactory(this.namingStrategy, this.module.getPackageName(), this.module.getPrefix(), this.module.getSuffix(), this.schemaToPackage) : new KeyDataFactory(this.namingStrategy, this.beanPackageName, this.module.getBeanPrefix(), this.module.getBeanSuffix(), this.schemaToPackage);
        String[] typesArray = null;
        if (this.tableTypesToExport != null && !this.tableTypesToExport.isEmpty()) {
            types = new ArrayList<String>();
            for (String tableType : this.tableTypesToExport.split(",")) {
                types.add(tableType.trim());
            }
            typesArray = types.toArray(new String[types.size()]);
        } else if (!this.exportAll) {
            types = new ArrayList(2);
            if (this.exportTables) {
                types.add("TABLE");
            }
            if (this.exportViews) {
                types.add("VIEW");
            }
            typesArray = types.toArray(new String[types.size()]);
        }
        ImmutableList schemas = Arrays.asList(this.schemaPattern);
        if (this.schemaPattern != null && this.schemaPattern.contains(",")) {
            schemas = ImmutableList.copyOf((Object[])this.schemaPattern.split(","));
        }
        ImmutableList tables = Arrays.asList(this.tableNamePattern);
        if (this.tableNamePattern != null && this.tableNamePattern.contains(",")) {
            tables = ImmutableList.copyOf((Object[])this.tableNamePattern.split(","));
        }
        for (String schema : schemas) {
            schema = schema != null ? schema.trim() : null;
            for (String table : tables) {
                table = table != null ? table.trim() : null;
                this.handleTables(md, schema, table, typesArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTables(DatabaseMetaData md, String schemaPattern, String tablePattern, String[] types) throws SQLException {
        ResultSet tables = md.getTables(null, schemaPattern, tablePattern, types);
        try {
            while (tables.next()) {
                this.handleTable(md, tables);
            }
        }
        finally {
            tables.close();
        }
    }

    Set<String> getClasses() {
        return this.classes;
    }

    private void handleColumn(EntityType classModel, String tableName, ResultSet columns) throws SQLException {
        String columnName = this.normalize(columns.getString("COLUMN_NAME"));
        String normalizedColumnName = this.namingStrategy.normalizeColumnName(columnName);
        int columnType = columns.getInt("DATA_TYPE");
        String typeName = columns.getString("TYPE_NAME");
        Number columnSize = (Number)columns.getObject("COLUMN_SIZE");
        Number columnDigits = (Number)columns.getObject("DECIMAL_DIGITS");
        int columnIndex = columns.getInt("ORDINAL_POSITION");
        int nullable = columns.getInt("NULLABLE");
        String propertyName = this.namingStrategy.getPropertyName(normalizedColumnName, classModel);
        Class<Object> clazz = this.configuration.getJavaType(columnType, typeName, columnSize != null ? columnSize.intValue() : 0, columnDigits != null ? columnDigits.intValue() : 0, tableName, columnName);
        if (clazz == null) {
            clazz = Object.class;
        }
        TypeCategory fieldType = TypeCategory.get((String)clazz.getName());
        if (Number.class.isAssignableFrom(clazz)) {
            fieldType = TypeCategory.NUMERIC;
        } else if (Enum.class.isAssignableFrom(clazz)) {
            fieldType = TypeCategory.ENUM;
        }
        ClassType typeModel = new ClassType(fieldType, clazz, new Type[0]);
        Property property = this.createProperty(classModel, normalizedColumnName, propertyName, (Type)typeModel);
        ColumnMetadata column = ColumnMetadata.named((String)normalizedColumnName).ofType(columnType).withIndex(columnIndex);
        if (nullable == 0) {
            column = column.notNull();
        }
        if (columnSize != null) {
            column = column.withSize(columnSize.intValue());
        }
        if (columnDigits != null) {
            column = column.withDigits(columnDigits.intValue());
        }
        property.getData().put("COLUMN", column);
        if (this.columnAnnotations) {
            property.addAnnotation((Annotation)new ColumnImpl(normalizedColumnName));
        }
        if (this.validationAnnotations) {
            int size;
            if (nullable == 0) {
                property.addAnnotation((Annotation)((Object)new NotNullImpl()));
            }
            if ((size = columns.getInt("COLUMN_SIZE")) > 0 && clazz.equals(String.class)) {
                property.addAnnotation((Annotation)((Object)new SizeImpl(0, size)));
            }
        }
        classModel.addProperty(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTable(DatabaseMetaData md, ResultSet tables) throws SQLException {
        Map<String, PrimaryKeyData> primaryKeyData;
        String normalizedTableName;
        String catalog = tables.getString("TABLE_CAT");
        String schema = tables.getString("TABLE_SCHEM");
        String schemaName = this.normalize(tables.getString("TABLE_SCHEM"));
        String tableName = this.normalize(tables.getString("TABLE_NAME"));
        String normalizedSchemaName = this.namingStrategy.normalizeSchemaName(schemaName);
        SchemaAndTable schemaAndTable = new SchemaAndTable(normalizedSchemaName, normalizedTableName = this.namingStrategy.normalizeTableName(tableName));
        if (!this.namingStrategy.shouldGenerateClass(schemaAndTable)) {
            return;
        }
        String className = this.namingStrategy.getClassName(schemaAndTable);
        EntityType classModel = this.createEntityType(schemaAndTable, className);
        if (this.exportPrimaryKeys && !(primaryKeyData = this.keyDataFactory.getPrimaryKeys(md, catalog, schema, tableName)).isEmpty()) {
            classModel.getData().put(PrimaryKeyData.class, primaryKeyData.values());
        }
        if (this.exportForeignKeys) {
            Map<String, InverseForeignKeyData> inverseForeignKeyData;
            Map<String, ForeignKeyData> foreignKeyData;
            if (this.exportDirectForeignKeys && !(foreignKeyData = this.keyDataFactory.getImportedKeys(md, catalog, schema, tableName)).isEmpty()) {
                HashSet<ForeignKeyData> foreignKeysToGenerate = new HashSet<ForeignKeyData>();
                for (ForeignKeyData fkd : foreignKeyData.values()) {
                    if (!this.namingStrategy.shouldGenerateForeignKey(schemaAndTable, fkd)) continue;
                    foreignKeysToGenerate.add(fkd);
                }
                if (!foreignKeysToGenerate.isEmpty()) {
                    classModel.getData().put(ForeignKeyData.class, foreignKeysToGenerate);
                }
            }
            if (this.exportInverseForeignKeys && !(inverseForeignKeyData = this.keyDataFactory.getExportedKeys(md, catalog, schema, tableName)).isEmpty()) {
                classModel.getData().put(InverseForeignKeyData.class, inverseForeignKeyData.values());
            }
        }
        ResultSet columns = md.getColumns(catalog, schema, tableName.replace("/", "//"), null);
        try {
            while (columns.next()) {
                this.handleColumn(classModel, tableName, columns);
            }
        }
        finally {
            columns.close();
        }
        this.serialize(classModel, schemaAndTable);
        logger.info("Exported " + tableName + " successfully");
    }

    private String normalize(String str) {
        if (this.lowerCase && str != null) {
            return str.toLowerCase();
        }
        return str;
    }

    private void serialize(EntityType type, SchemaAndTable schemaAndTable) {
        try {
            String fileSuffix;
            String string = fileSuffix = this.createScalaSources ? ".scala" : ".java";
            if (this.beanSerializer != null) {
                String packageName = this.normalizePackage(this.beanPackageName, schemaAndTable);
                String path = packageName.replace('.', '/') + "/" + type.getSimpleName() + fileSuffix;
                this.write(this.beanSerializer, new File(this.beansTargetFolder, path), type);
                String otherPath = this.entityToWrapped.get(type).getFullName().replace('.', '/') + fileSuffix;
                this.write(this.serializer, new File(this.targetFolder, otherPath), type);
            } else {
                String packageName = this.normalizePackage(this.module.getPackageName(), schemaAndTable);
                String path = packageName.replace('.', '/') + "/" + type.getSimpleName() + fileSuffix;
                this.write(this.serializer, new File(this.targetFolder, path), type);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void write(Serializer serializer, File targetFile, EntityType type) throws IOException {
        if (!this.classes.add(targetFile.getPath())) {
            throw new IllegalStateException("Attempted to write multiple times to " + targetFile.getPath() + ", please check your configuration");
        }
        StringWriter w = new StringWriter();
        ScalaWriter writer = this.createScalaSources ? new ScalaWriter((Appendable)w) : new JavaWriter((Appendable)w);
        serializer.serialize(type, SimpleSerializerConfig.DEFAULT, (CodeWriter)writer);
        boolean generate = true;
        byte[] bytes = w.toString().getBytes(this.sourceEncoding);
        if (targetFile.exists() && targetFile.length() == (long)bytes.length) {
            String str = Files.toString((File)targetFile, (Charset)Charset.forName(this.sourceEncoding));
            if (str.equals(w.toString())) {
                generate = false;
            }
        } else {
            targetFile.getParentFile().mkdirs();
        }
        if (generate) {
            Files.write((byte[])bytes, (File)targetFile);
        }
    }

    public void setSchemaPattern(@Nullable String schemaPattern) {
        this.schemaPattern = schemaPattern;
    }

    public void setTableNamePattern(@Nullable String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setConfiguration(Configuration configuration) {
        this.module.bind(Configuration.class, configuration);
    }

    public void setCreateScalaSources(boolean createScalaSources) {
        this.createScalaSources = createScalaSources;
    }

    public void setTargetFolder(File targetFolder) {
        this.targetFolder = targetFolder;
    }

    public void setBeansTargetFolder(File targetFolder) {
        this.beansTargetFolder = targetFolder;
    }

    public void setPackageName(String packageName) {
        this.module.bind("packageName", packageName);
    }

    public void setBeanPackageName(@Nullable String beanPackageName) {
        this.beanPackageName = beanPackageName;
    }

    public void setNamePrefix(String namePrefix) {
        this.module.bind("prefix", namePrefix);
    }

    public void setNameSuffix(String nameSuffix) {
        this.module.bind("suffix", nameSuffix);
    }

    public void setBeanPrefix(String beanPrefix) {
        this.module.bind("beanPrefix", beanPrefix);
    }

    public void setBeanSuffix(String beanSuffix) {
        this.module.bind("beanSuffix", beanSuffix);
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.module.bind(NamingStrategy.class, namingStrategy);
    }

    public void setBeanSerializer(@Nullable Serializer beanSerializer) {
        this.module.bind("beanSerializer", beanSerializer);
    }

    public void setBeanSerializerClass(Class<? extends Serializer> beanSerializerClass) {
        this.module.bind("beanSerializer", beanSerializerClass);
    }

    public void setInnerClassesForKeys(boolean innerClassesForKeys) {
        this.module.bind("innerClassesForKeys", innerClassesForKeys);
    }

    public void setColumnComparatorClass(Class<? extends Comparator<Property>> columnComparatorClass) {
        this.module.bind("columnComparator", columnComparatorClass);
    }

    public void setSerializerClass(Class<? extends Serializer> serializerClass) {
        this.module.bind(Serializer.class, serializerClass);
    }

    public void setTypeMappings(TypeMappings typeMappings) {
        this.module.bind(TypeMappings.class, typeMappings);
    }

    public void setColumnAnnotations(boolean columnAnnotations) {
        this.columnAnnotations = columnAnnotations;
    }

    public void setValidationAnnotations(boolean validationAnnotations) {
        this.validationAnnotations = validationAnnotations;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    @Deprecated
    public void setSchemaToPackage(boolean schemaToPackage) {
        this.schemaToPackage = schemaToPackage;
        this.module.bind("schemaToPackage", schemaToPackage);
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    public void setExportTables(boolean exportTables) {
        this.exportTables = exportTables;
    }

    public void setExportViews(boolean exportViews) {
        this.exportViews = exportViews;
    }

    public void setExportAll(boolean exportAll) {
        this.exportAll = exportAll;
    }

    public void setExportPrimaryKeys(boolean exportPrimaryKeys) {
        this.exportPrimaryKeys = exportPrimaryKeys;
    }

    public void setExportForeignKeys(boolean exportForeignKeys) {
        this.exportForeignKeys = exportForeignKeys;
    }

    public void setExportDirectForeignKeys(boolean exportDirectForeignKeys) {
        this.exportDirectForeignKeys = exportDirectForeignKeys;
    }

    public void setExportInverseForeignKeys(boolean exportInverseForeignKeys) {
        this.exportInverseForeignKeys = exportInverseForeignKeys;
    }

    public void setImports(String[] imports) {
        this.module.bind("imports", new HashSet<String>(Arrays.asList(imports)));
    }

    public void setSpatial(boolean spatial) {
        this.spatial = spatial;
    }

    public void setTableTypesToExport(String tableTypesToExport) {
        this.tableTypesToExport = tableTypesToExport;
    }
}

