/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import java.lang.annotation.Annotation;
import org.jetbrains.annotations.Nullable;

public final class GeneratedAnnotationResolver {
    private static final Class<? extends Annotation> DEFAULT_GENERATED_ANNOTATION_CLASS = GeneratedAnnotationResolver.resolveJavaDefault();

    public static Class<? extends Annotation> resolve(@Nullable String generatedAnnotationClass) {
        if (generatedAnnotationClass != null) {
            try {
                return Class.forName(generatedAnnotationClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return GeneratedAnnotationResolver.resolveDefault();
    }

    public static Class<? extends Annotation> resolveDefault() {
        return DEFAULT_GENERATED_ANNOTATION_CLASS;
    }

    private static Class<? extends Annotation> resolveJavaDefault() {
        try {
            return Class.forName("javax.annotation.processing.Generated");
        }
        catch (Exception exception) {
            try {
                return Class.forName("javax.annotation.Generated");
            }
            catch (Exception exception2) {
                try {
                    return Class.forName("jakarta.annotation.Generated");
                }
                catch (Exception exception3) {
                    throw new IllegalStateException("Can't find Generated annotation");
                }
            }
        }
    }

    private GeneratedAnnotationResolver() {
    }
}

