/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.util.HashSet;

public class OServerCommandGetSupportedLanguages
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|supportedLanguages/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 2, "Syntax error: supportedLanguages/<database>");
        iRequest.data.commandInfo = "Returns the supported languages";
        ODatabaseDocumentTx db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            ODocument result = new ODocument();
            HashSet<String> languages = new HashSet<String>();
            OScriptManager scriptManager = Orient.instance().getScriptManager();
            for (String language : scriptManager.getSupportedLanguages()) {
                if (scriptManager.getFormatters() == null || scriptManager.getFormatters().get(language) == null) continue;
                languages.add(language);
            }
            result.field("languages", languages);
            iResponse.writeRecord((ORecord)result);
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

