/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.sql;

import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLFactory;
import com.orientechnologies.orient.server.distributed.sql.OCommandExecutorSQLSyncCluster;
import com.orientechnologies.orient.server.distributed.sql.OCommandExecutorSQLSyncDatabase;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ODistributedCommandExecutorSQLFactory
implements OCommandExecutorSQLFactory {
    private static final Map<String, Class<? extends OCommandExecutorSQLAbstract>> COMMANDS;

    public Set<String> getCommandNames() {
        return COMMANDS.keySet();
    }

    public OCommandExecutorSQLAbstract createCommand(String name) throws OCommandExecutionException {
        Class<? extends OCommandExecutorSQLAbstract> clazz = COMMANDS.get(name);
        if (clazz == null) {
            throw new OCommandExecutionException("Unknown command name :" + name);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new OCommandExecutionException("Error in creation of command " + name + "(). Probably there is not an empty constructor or the constructor generates errors", (Throwable)e);
        }
    }

    static {
        HashMap<String, Class> commands = new HashMap<String, Class>();
        commands.put("SYNC DATABASE", OCommandExecutorSQLSyncDatabase.class);
        commands.put("SYNC CLUSTER", OCommandExecutorSQLSyncCluster.class);
        COMMANDS = Collections.unmodifiableMap(commands);
    }
}

