/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;

final class ProcessOutputLogger
implements Runnable {
    private final Logger logger;
    private final Process process;
    private final BufferedReader reader;

    private ProcessOutputLogger(Logger logger, Process process) {
        this.logger = logger;
        this.process = process;
        this.reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
    }

    @Override
    public void run() {
        while (this.process.isAlive()) {
            try {
                this.logger.info(this.reader.readLine());
            }
            catch (IOException e) {
                this.logger.error("while reading output", (Throwable)e);
                return;
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    this.logger.error("caught i/o exception closing reader", (Throwable)e);
                }
            }
        }
    }

    static void logOutput(Logger logger, Process process) {
        Thread t = new Thread(new ProcessOutputLogger(logger, process));
        t.setName("output redirector for " + process);
        t.start();
    }
}

