/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.constants;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public final class Idents {
    private static final String RCSS_NUMBER = "(-)?((\\d){1,10}((\\.)(\\d){1,10})?)";
    private static final String RCSS_LENGTH = "((0$)|(((-)?((\\d){1,10}((\\.)(\\d){1,10})?))+((em)|(ex)|(px)|(cm)|(mm)|(in)|(pt)|(pc)|(%))))";
    private static final Pattern CSS_LENGTH_PATTERN = Pattern.compile("((0$)|(((-)?((\\d){1,10}((\\.)(\\d){1,10})?))+((em)|(ex)|(px)|(cm)|(mm)|(in)|(pt)|(pc)|(%))))");
    private static final Set<String> BACKGROUND_POSITIONS_IDENTS = new HashSet<String>(Arrays.asList("top", "center", "bottom", "right", "left"));

    public static boolean looksLikeALength(String val) {
        return CSS_LENGTH_PATTERN.matcher(val).matches();
    }

    public static boolean looksLikeABGPosition(String val) {
        return BACKGROUND_POSITIONS_IDENTS.contains(val) || Idents.looksLikeALength(val);
    }
}

