/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.resource;

import com.openhtmltopdf.resource.XMLResource;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import com.openhtmltopdf.util.XRRuntimeException;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FSCatalog {
    public Map<String, String> parseCatalog(String catalogURI) {
        Map<String, String> map = null;
        try (InputStream in = FSCatalog.class.getResourceAsStream(catalogURI);){
            map = this.parseCatalog(new InputSource(new BufferedInputStream(in)));
        }
        catch (Exception ex) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.XML_ENTITIES_COULD_NOT_OPEN_XML_CATALOG_FROM_URI, (Object)catalogURI, ex);
            map = Collections.emptyMap();
        }
        return map;
    }

    public Map<String, String> parseCatalog(InputSource inputSource) {
        XMLReader xmlReader = XMLResource.newXMLReader();
        CatalogContentHandler ch = new CatalogContentHandler();
        this.addHandlers(xmlReader, ch);
        this.setFeature(xmlReader, "http://xml.org/sax/features/validation", false);
        try {
            xmlReader.parse(inputSource);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed on configuring SAX to DOM transformer.", ex);
        }
        return ch.getEntityMap();
    }

    private void addHandlers(XMLReader xmlReader, ContentHandler ch) {
        try {
            xmlReader.setContentHandler(ch);
            xmlReader.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException ex) {
                    if (XRLog.isLoggingEnabled()) {
                        XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.XML_ENTITIES_EXCEPTION_MESSAGE, ex.getMessage());
                    }
                }

                @Override
                public void fatalError(SAXParseException ex) {
                    if (XRLog.isLoggingEnabled()) {
                        XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.XML_ENTITIES_EXCEPTION_MESSAGE, ex.getMessage());
                    }
                }

                @Override
                public void warning(SAXParseException ex) {
                    if (XRLog.isLoggingEnabled()) {
                        XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.XML_ENTITIES_EXCEPTION_MESSAGE, ex.getMessage());
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new XRRuntimeException("Failed on configuring SAX parser/XMLReader.", ex);
        }
    }

    private void setFeature(XMLReader xmlReader, String featureUri, boolean value) {
        try {
            xmlReader.setFeature(featureUri, value);
            XRLog.log(Level.FINE, LogMessageId.LogMessageId2Param.XML_ENTITIES_SAX_FEATURE_SET, (Object)featureUri.substring(featureUri.lastIndexOf("/")), (Object)Boolean.toString(xmlReader.getFeature(featureUri)));
        }
        catch (SAXNotSupportedException ex) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.XML_ENTITIES_SAX_FEATURE_NOT_SUPPORTED, featureUri);
        }
        catch (SAXNotRecognizedException ex) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.XML_ENTITIES_SAX_FEATURE_NOT_RECOGNIZED, featureUri);
        }
    }

    private static class CatalogContentHandler
    extends DefaultHandler {
        private final Map<String, String> entityMap = new HashMap<String, String>();

        public Map<String, String> getEntityMap() {
            return this.entityMap;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            if (localName.equalsIgnoreCase("public") || localName.equals("") && qName.equalsIgnoreCase("public")) {
                this.entityMap.put(atts.getValue("publicId"), atts.getValue("uri"));
            }
        }
    }
}

