/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.extend.FSTextBreaker;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.LineBreakContext;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.layout.TextUtil;
import com.openhtmltopdf.render.FSFont;

public class Breaker {
    public static final TextBreakerSupplier STANDARD_CHARACTER_BREAKER = new CharacterBreakerSupplier();
    public static final TextBreakerSupplier STANDARD_LINE_BREAKER = new LineBreakerSupplier();

    public static void breakFirstLetter(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style) {
        FSFont font = style.getFSFont(c);
        float letterSpacing = style.hasLetterSpacing() ? style.getFloatPropertyProportionalWidth(CSSName.LETTER_SPACING, 0.0f, c) : 0.0f;
        context.setEnd(Breaker.getFirstLetterEnd(context.getMaster(), context.getStart()));
        context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()) + (int)letterSpacing);
        if (context.getWidth() > avail) {
            context.setNeedsNewLine(true);
            context.setUnbreakable(true);
        }
    }

    private static int getFirstLetterEnd(String text, int start) {
        int currentChar;
        boolean letterFound = false;
        int end = text.length();
        for (int i = start; i < end; i += Character.charCount(currentChar)) {
            currentChar = text.codePointAt(i);
            if (TextUtil.isFirstLetterSeparatorChar(currentChar)) continue;
            if (letterFound) {
                return i;
            }
            letterFound = true;
        }
        return end;
    }

    public static void breakText(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style) {
        FSFont font = style.getFSFont(c);
        IdentValue whitespace = style.getWhitespace();
        if (whitespace == IdentValue.NOWRAP) {
            context.setEnd(context.getLast());
            context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()));
            return;
        }
        if (whitespace == IdentValue.PRE || whitespace == IdentValue.PRE_WRAP || whitespace == IdentValue.PRE_LINE) {
            int n = context.getStartSubstring().indexOf("\n");
            if (n > -1) {
                context.setEnd(context.getStart() + n + 1);
                context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()));
                context.setNeedsNewLine(true);
                context.setEndsOnNL(true);
            } else if (whitespace == IdentValue.PRE) {
                context.setEnd(context.getLast());
                context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()));
            }
        }
        if (whitespace == IdentValue.PRE || context.isNeedsNewLine() && context.getWidth() <= avail) {
            return;
        }
        context.setEndsOnNL(false);
        Breaker.doBreakText(c, context, avail, style, false);
    }

    private static void doBreakText(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style, boolean tryToBreakAnywhere) {
        Breaker.doBreakText(c, context, avail, style, STANDARD_CHARACTER_BREAKER, STANDARD_LINE_BREAKER, tryToBreakAnywhere);
    }

    public static void doBreakText(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style, TextBreakerSupplier characterBreaker, TextBreakerSupplier lineBreaker, boolean tryToBreakAnywhere) {
        FSFont font = style.getFSFont(c);
        float letterSpacing = style.hasLetterSpacing() ? style.getFloatPropertyProportionalWidth(CSSName.LETTER_SPACING, 0.0f, c) : 0.0f;
        String currentString = context.getStartSubstring();
        FSTextBreaker iterator = tryToBreakAnywhere ? characterBreaker.getBreaker(currentString, c.getSharedContext()) : lineBreaker.getBreaker(currentString, c.getSharedContext());
        int left = 0;
        int right = iterator.next();
        int lastWrap = 0;
        int graphicsLength = 0;
        int lastGraphicsLength = 0;
        while (right > 0 && graphicsLength <= avail) {
            lastGraphicsLength = graphicsLength;
            graphicsLength = (int)((float)graphicsLength + ((float)c.getTextRenderer().getWidth(c.getFontContext(), font, currentString.substring(left, right)) + (float)(right - left) * letterSpacing));
            lastWrap = left;
            left = right;
            right = iterator.next();
        }
        if (graphicsLength <= avail) {
            lastWrap = left;
            lastGraphicsLength = graphicsLength;
            graphicsLength += c.getTextRenderer().getWidth(c.getFontContext(), font, currentString.substring(left));
        }
        if (graphicsLength <= avail) {
            context.setWidth(graphicsLength);
            context.setEnd(context.getMaster().length());
            return;
        }
        context.setNeedsNewLine(true);
        if (lastWrap == 0 && style.getWordWrap() == IdentValue.BREAK_WORD && !tryToBreakAnywhere) {
            Breaker.doBreakText(c, context, avail, style, characterBreaker, lineBreaker, true);
            return;
        }
        if (lastWrap != 0) {
            context.setEnd(context.getStart() + lastWrap);
            context.setWidth(lastGraphicsLength);
        } else {
            if (left == 0) {
                left = currentString.length();
            }
            context.setEnd(context.getStart() + left);
            context.setUnbreakable(true);
            if (left == currentString.length()) {
                context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()));
            } else {
                context.setWidth(graphicsLength);
            }
        }
    }

    public static FSTextBreaker getCharacterBreakStream(String currentString, SharedContext sharedContext) {
        FSTextBreaker i = sharedContext.getCharacterBreaker();
        i.setText(currentString);
        return i;
    }

    public static FSTextBreaker getLineBreakStream(String s, SharedContext shared) {
        FSTextBreaker i = shared.getLineBreaker();
        i.setText(s);
        return i;
    }

    private static class LineBreakerSupplier
    implements TextBreakerSupplier {
        private LineBreakerSupplier() {
        }

        @Override
        public FSTextBreaker getBreaker(String str, SharedContext sharedContext) {
            return Breaker.getLineBreakStream(str, sharedContext);
        }
    }

    private static class CharacterBreakerSupplier
    implements TextBreakerSupplier {
        private CharacterBreakerSupplier() {
        }

        @Override
        public FSTextBreaker getBreaker(String str, SharedContext sharedContext) {
            return Breaker.getCharacterBreakStream(str, sharedContext);
        }
    }

    public static interface TextBreakerSupplier {
        public FSTextBreaker getBreaker(String var1, SharedContext var2);
    }
}

