/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryFlag;
import com.mysema.query.types.Constant;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.FactoryExpressionUtils;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.PredicateOperation;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.SubQueryExpressionImpl;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.TemplateExpressionImpl;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.template.BooleanTemplate;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ReplaceVisitor
implements Visitor<Expression<?>, Void> {
    @Override
    public Expression<?> visit(Constant<?> expr, @Nullable Void context) {
        return expr;
    }

    @Override
    public Expression<?> visit(FactoryExpression<?> expr, @Nullable Void context) {
        ImmutableList<Expression<?>> args = this.visit(expr.getArgs());
        if (args.equals(expr.getArgs())) {
            return expr;
        }
        return FactoryExpressionUtils.wrap(expr, args);
    }

    @Override
    public Expression<?> visit(Operation<?> expr, @Nullable Void context) {
        ImmutableList<Expression<?>> args = this.visit(expr.getArgs());
        if (args.equals(expr.getArgs())) {
            return expr;
        }
        if (expr instanceof Predicate) {
            return new PredicateOperation(expr.getOperator(), args);
        }
        return new OperationImpl(expr.getType(), expr.getOperator(), args);
    }

    @Override
    public Expression<?> visit(ParamExpression<?> expr, @Nullable Void context) {
        return expr;
    }

    @Override
    public Expression<?> visit(Path<?> expr, @Nullable Void context) {
        if (expr.getMetadata().isRoot()) {
            return expr;
        }
        PathMetadata<Object> metadata = expr.getMetadata();
        Path parent = (Path)metadata.getParent().accept(this, null);
        Object element = metadata.getElement();
        if (element instanceof Expression) {
            element = ((Expression)element).accept(this, null);
        }
        if (parent.equals(metadata.getParent()) && Objects.equal((Object)element, (Object)metadata.getElement())) {
            return expr;
        }
        metadata = new PathMetadata(parent, element, metadata.getPathType());
        return new PathImpl(expr.getType(), metadata);
    }

    @Override
    public Expression<?> visit(SubQueryExpression<?> expr, @Nullable Void context) {
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        md.setValidate(false);
        md.setDistinct(expr.getMetadata().isDistinct());
        md.setModifiers(expr.getMetadata().getModifiers());
        md.setUnique(expr.getMetadata().isUnique());
        for (QueryFlag queryFlag : expr.getMetadata().getFlags()) {
            md.addFlag(new QueryFlag(queryFlag.getPosition(), (Expression)queryFlag.getFlag().accept(this, null)));
        }
        for (Expression expression : expr.getMetadata().getGroupBy()) {
            md.addGroupBy((Expression)expression.accept(this, null));
        }
        Predicate having = expr.getMetadata().getHaving();
        if (having != null) {
            md.addHaving((Predicate)having.accept(this, null));
        }
        for (JoinExpression joinExpression : expr.getMetadata().getJoins()) {
            md.addJoin(joinExpression.getType(), (Expression)joinExpression.getTarget().accept(this, null));
            if (joinExpression.getCondition() != null) {
                md.addJoinCondition((Predicate)joinExpression.getCondition().accept(this, null));
            }
            for (JoinFlag jf : joinExpression.getFlags()) {
                md.addJoinFlag(new JoinFlag((Expression)jf.getFlag().accept(this, null), jf.getPosition()));
            }
        }
        for (OrderSpecifier<?> orderSpecifier : expr.getMetadata().getOrderBy()) {
            OrderSpecifier os2 = new OrderSpecifier(orderSpecifier.getOrder(), (Expression)orderSpecifier.getTarget().accept(this, null));
            switch (orderSpecifier.getNullHandling()) {
                case NullsFirst: {
                    os2 = os2.nullsFirst();
                    break;
                }
                case NullsLast: {
                    os2 = os2.nullsLast();
                }
            }
            md.addOrderBy(os2);
        }
        for (Map.Entry<ParamExpression<?>, Object> entry : expr.getMetadata().getParams().entrySet()) {
            md.setParam((ParamExpression)entry.getKey().accept(this, null), entry.getValue());
        }
        for (Expression<?> expression : expr.getMetadata().getProjection()) {
            md.addProjection((Expression)expression.accept(this, null));
        }
        Predicate predicate = expr.getMetadata().getWhere();
        if (predicate != null) {
            md.addWhere((Predicate)predicate.accept(this, null));
        }
        if (expr.getMetadata().equals(md)) {
            return expr;
        }
        return new SubQueryExpressionImpl(expr.getType(), md);
    }

    @Override
    public Expression<?> visit(TemplateExpression<?> expr, @Nullable Void context) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object arg : expr.getArgs()) {
            if (arg instanceof Expression) {
                builder.add(((Expression)arg).accept(this, null));
                continue;
            }
            builder.add(arg);
        }
        ImmutableList args = builder.build();
        if (args.equals(expr.getArgs())) {
            return expr;
        }
        if (expr instanceof Predicate) {
            return BooleanTemplate.create(expr.getTemplate(), args);
        }
        return new TemplateExpressionImpl(expr.getType(), expr.getTemplate(), args);
    }

    private ImmutableList<Expression<?>> visit(List<Expression<?>> args) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression<?> arg : args) {
            builder.add(arg.accept(this, null));
        }
        return builder.build();
    }
}

