/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.ExpressionException;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.Visitor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.BeanMap;

public class QBean<T>
extends ExpressionBase<T>
implements FactoryExpression<T> {
    private static final long serialVersionUID = -8210214512730989778L;
    private static final Map<Path<?>, String> pathToProperty = Collections.synchronizedMap(new HashMap());
    private static Class<?> RelationalPathClass = null;
    private final Map<String, ? extends Expression<?>> bindings;
    private final Map<String, Field> fields = new HashMap<String, Field>();
    private final List<Expression<?>> args;
    private final boolean fieldAccess;

    private static final String resolvePropertyViaFields(Path<?> path) {
        String property = pathToProperty.get(path);
        if (property == null) {
            Path<?> parent = path.getMetadata().getParent();
            for (Field field : parent.getClass().getFields()) {
                try {
                    if (field.get(parent) != path) continue;
                    property = field.getName();
                    break;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if (property == null) {
                property = path.getMetadata().getExpression().toString();
            }
            pathToProperty.put(path, property);
        }
        return property;
    }

    private static Map<String, Expression<?>> createBindings(Expression<?> ... args) {
        LinkedHashMap rv = new LinkedHashMap(args.length);
        for (Expression<?> expr : args) {
            if (expr instanceof Path) {
                Path path = (Path)expr;
                String property = path.getMetadata().getParent() != null && RelationalPathClass != null && RelationalPathClass.isAssignableFrom(path.getMetadata().getParent().getClass()) ? QBean.resolvePropertyViaFields(path) : path.getMetadata().getExpression().toString();
                rv.put(property, expr);
                continue;
            }
            if (expr instanceof Operation) {
                Operation operation = (Operation)expr;
                if (operation.getOperator() == Ops.ALIAS && operation.getArg(1) instanceof Path) {
                    Path path = (Path)operation.getArg(1);
                    rv.put(path.getMetadata().getExpression().toString(), operation.getArg(0));
                    continue;
                }
                throw new IllegalArgumentException("Unsupported expression " + expr);
            }
            throw new IllegalArgumentException("Unsupported expression " + expr);
        }
        return rv;
    }

    public QBean(Path<T> type, Expression<?> ... args) {
        this(type.getType(), false, args);
    }

    public QBean(Path<T> type, Map<String, ? extends Expression<?>> bindings) {
        this(type.getType(), false, bindings);
    }

    public QBean(Path<T> type, boolean fieldAccess, Expression<?> ... args) {
        this(type.getType(), fieldAccess, args);
    }

    public QBean(Path<T> type, boolean fieldAccess, Map<String, ? extends Expression<?>> bindings) {
        this(type.getType(), fieldAccess, bindings);
    }

    public QBean(Class<T> type, Map<String, ? extends Expression<?>> bindings) {
        this(type, false, bindings);
    }

    public QBean(Class<T> type, Expression<?> ... args) {
        this(type, false, args);
    }

    public QBean(Class<T> type, boolean fieldAccess, Expression<?> ... args) {
        this(type, fieldAccess, QBean.createBindings(args));
    }

    public QBean(Class<T> type, boolean fieldAccess, Map<String, ? extends Expression<?>> bindings) {
        super(type);
        this.bindings = bindings;
        this.args = new ArrayList(bindings.values());
        this.fieldAccess = fieldAccess;
        if (fieldAccess) {
            this.initFields();
        }
    }

    private void initFields() {
        for (String property : this.bindings.keySet()) {
            Class<Object> beanType = this.type;
            while (!beanType.equals(Object.class)) {
                try {
                    Field field = beanType.getDeclaredField(property);
                    field.setAccessible(true);
                    this.fields.put(property, field);
                    beanType = Object.class;
                }
                catch (SecurityException e) {
                }
                catch (NoSuchFieldException e) {
                    beanType = beanType.getSuperclass();
                }
            }
        }
    }

    @Override
    public T newInstance(Object ... a) {
        try {
            Object rv = this.getType().newInstance();
            if (this.fieldAccess) {
                for (Map.Entry<String, Expression<?>> entry : this.bindings.entrySet()) {
                    Object value = a[this.args.indexOf(entry.getValue())];
                    if (value == null) continue;
                    this.fields.get(entry.getKey()).set(rv, value);
                }
            } else {
                BeanMap beanMap = new BeanMap(rv);
                for (Map.Entry<String, Expression<?>> entry : this.bindings.entrySet()) {
                    Object value = a[this.args.indexOf(entry.getValue())];
                    if (value == null) continue;
                    beanMap.put(entry.getKey(), value);
                }
            }
            return rv;
        }
        catch (InstantiationException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
    }

    public Expression<T> as(Path<T> alias) {
        return OperationImpl.create(this.getType(), Ops.ALIAS, this, alias);
    }

    public Expression<T> as(String alias) {
        return this.as(new PathImpl(this.getType(), alias));
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QBean) {
            QBean c = (QBean)obj;
            return ((Object)this.args).equals(c.args) && this.getType().equals(c.getType());
        }
        return false;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    @Override
    public List<Expression<?>> getArgs() {
        return this.args;
    }

    static {
        try {
            RelationalPathClass = Class.forName("com.mysema.query.sql.RelationalPath");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

