/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.group;

import com.mysema.commons.lang.Pair;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Visitor;
import java.util.Arrays;
import java.util.List;

public final class QPair<K, V>
extends ExpressionBase<Pair<K, V>>
implements FactoryExpression<Pair<K, V>> {
    private static final long serialVersionUID = -1943990903548916056L;
    private final Expression<K> key;
    private final Expression<V> value;

    public static <K, V> QPair<K, V> create(Expression<K> key, Expression<V> value) {
        return new QPair<K, V>(key, value);
    }

    public QPair(Expression<K> key, Expression<V> value) {
        super(Pair.class);
        this.key = key;
        this.value = value;
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    @Override
    public List<Expression<?>> getArgs() {
        return Arrays.asList(this.key, this.value);
    }

    public boolean equals(Expression<?> keyExpr, Expression<?> valueExpr) {
        return this.key.equals(keyExpr) && this.value.equals(valueExpr);
    }

    public boolean equals(Expression<?> keyExpr, Class<?> valueType) {
        return this.key.equals(keyExpr) && valueType.isAssignableFrom(this.value.getType());
    }

    @Override
    public Pair<K, V> newInstance(Object ... args) {
        return new Pair(args[0], args[1]);
    }

    public int hashCode() {
        return 31 * this.key.hashCode() + this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof QPair) {
            QPair other = (QPair)o;
            return this.key.equals(other.key) && this.value.equals(other.value);
        }
        return false;
    }
}

