/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.group;

import com.mysema.commons.lang.Assert;
import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.Pair;
import com.mysema.query.Projectable;
import com.mysema.query.ResultTransformer;
import com.mysema.query.group.AbstractGroupColumnDefinition;
import com.mysema.query.group.Group;
import com.mysema.query.group.GroupColumn;
import com.mysema.query.group.GroupColumnDefinition;
import com.mysema.query.group.GroupProcessor;
import com.mysema.query.group.GroupProcessorFactory;
import com.mysema.query.group.ProcessorGroupBy;
import com.mysema.query.group.QPair;
import com.mysema.query.group.ValueTransformerMap;
import com.mysema.query.types.Expression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections15.Transformer;

public class GroupBy<S>
implements ResultTransformer<Map<S, Group>> {
    protected final List<GroupColumnDefinition<?, ?>> columnDefinitions;
    private final GroupProcessor<S, Map<S, Group>> defaultProcessor = new GroupProcessor<S, Map<S, Group>>(){

        @Override
        public boolean accept(Object[] row) {
            return true;
        }

        public Map<S, Group> transform(Map<S, Group> groups) {
            return groups;
        }
    };
    private final List<QPair<?, ?>> maps;

    public static <T> GroupBy<T> create(Expression<T> expr) {
        return new GroupBy<T>(expr);
    }

    public static <T> GroupBy<T> create(Expression<T> expr, Expression<?> first, Expression<?> ... rest) {
        return new GroupBy<T>(expr, first, rest);
    }

    public GroupBy(Expression<S> groupBy) {
        this(new ArrayList(), new ArrayList());
        this.withGroup(new GOne<S>(groupBy));
    }

    public GroupBy(Expression<S> groupBy, Expression<?> first, Expression<?> ... rest) {
        this(groupBy);
        this.withOne(first);
        for (Expression<?> expr : rest) {
            this.withOne(expr);
        }
    }

    public <T> GroupBy(Expression<S> groupBy, GroupColumnDefinition<?, ?> group, GroupColumnDefinition<?, ?> ... groups) {
        this(groupBy);
        this.withGroup(group);
        for (GroupColumnDefinition<?, ?> g : groups) {
            this.withGroup(g);
        }
    }

    protected GroupBy(List<GroupColumnDefinition<?, ?>> columnDefinitions, List<QPair<?, ?>> maps) {
        this.columnDefinitions = columnDefinitions;
        this.maps = maps;
    }

    public List<GroupColumnDefinition<?, ?>> getColumnDefinitions() {
        return Collections.unmodifiableList(this.columnDefinitions);
    }

    private Expression<?>[] getExpressions() {
        Expression[] unwrapped = new Expression[this.columnDefinitions.size()];
        for (int i = 0; i < this.columnDefinitions.size(); ++i) {
            unwrapped[i] = this.columnDefinitions.get(i).getExpression();
        }
        return unwrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O> O process(Projectable projectable, GroupProcessor<S, O> processor) {
        Assert.notNull((Object)projectable, (String)"projectable");
        Assert.notNull(processor, (String)"processor");
        LinkedHashMap<Object, GroupImpl> groups = new LinkedHashMap<Object, GroupImpl>();
        CloseableIterator<Object[]> iter = projectable.iterate(this.getExpressions());
        try {
            while (iter.hasNext()) {
                Object[] row = (Object[])iter.next();
                if (!processor.accept(row)) continue;
                Object groupId = row[0];
                GroupImpl group = (GroupImpl)groups.get(groupId);
                if (group == null) {
                    group = new GroupImpl();
                    groups.put(groupId, group);
                }
                group.add(row);
            }
        }
        finally {
            iter.close();
        }
        return (O)processor.transform(groups);
    }

    @Override
    public Map<S, Group> transform(Projectable projectable) {
        return this.process(projectable, this.defaultProcessor);
    }

    public GroupBy<S> withGroup(GroupColumnDefinition<?, ?> g) {
        this.columnDefinitions.add(g);
        return this;
    }

    public <T> GroupBy<S> withList(Expression<T> expr) {
        return this.withGroup(new GList<T>(expr));
    }

    public <K, V> GroupBy<S> withMap(Expression<K> key, Expression<V> value) {
        QPair<K, V> qpair = new QPair<K, V>(key, value);
        this.maps.add(qpair);
        return this.withGroup(new GMap<K, V>(qpair));
    }

    public <T> GroupBy<S> withOne(Expression<T> expr) {
        return this.withGroup(new GOne<T>(expr));
    }

    public <O> ProcessorGroupBy<S, O> withProcessor(GroupProcessorFactory<S, O> processorFactory) {
        return ProcessorGroupBy.create(this, processorFactory);
    }

    public <O> ProcessorGroupBy<S, O> withProcessor(GroupProcessor<S, O> processor) {
        return ProcessorGroupBy.create(this, processor);
    }

    public <T> GroupBy<S> withSet(Expression<T> expr) {
        return this.withGroup(new GSet<T>(expr));
    }

    public <W> ProcessorGroupBy<S, W> withTransformer(final Transformer<Map<S, Group>, W> transformer) {
        return this.withProcessor(new GroupProcessor<S, W>(){

            public W transform(Map<S, Group> input) {
                return transformer.transform(input);
            }

            @Override
            public boolean accept(Object[] row) {
                return true;
            }
        });
    }

    public <W> ProcessorGroupBy<S, Map<S, W>> withValueTransformer(final Transformer<? super Group, ? extends W> transformer) {
        return this.withTransformer(new Transformer<Map<S, Group>, Map<S, W>>(){

            public Map<S, W> transform(Map<S, Group> input) {
                return ValueTransformerMap.create(input, transformer);
            }
        });
    }

    private static class GSet<T>
    extends AbstractGroupColumnDefinition<T, Set<T>> {
        public GSet(Expression<T> expr) {
            super(expr);
        }

        @Override
        public GroupColumn<Set<T>> createGroupColumn() {
            return new GroupColumn<Set<T>>(){
                private final Set<T> set = new LinkedHashSet();

                @Override
                public void add(Object o) {
                    this.set.add(o);
                }

                @Override
                public Set<T> get() {
                    return this.set;
                }
            };
        }
    }

    private class GroupImpl
    implements Group {
        private final Map<Expression<?>, GroupColumn<?>> groupColumns = new LinkedHashMap();

        public GroupImpl() {
            for (int i = 0; i < GroupBy.this.columnDefinitions.size(); ++i) {
                GroupColumnDefinition<?, ?> coldef = GroupBy.this.columnDefinitions.get(i);
                this.groupColumns.put(coldef.getExpression(), coldef.createGroupColumn());
            }
        }

        void add(Object[] row) {
            int i = 0;
            for (GroupColumn<?> groupColumn : this.groupColumns.values()) {
                groupColumn.add(row[i]);
                ++i;
            }
        }

        private <T, R> R get(Expression<T> expr) {
            GroupColumn<?> col = this.groupColumns.get(expr);
            if (col != null) {
                return (R)col.get();
            }
            throw new NoSuchElementException(expr.toString());
        }

        @Override
        public <T, R> R getGroup(GroupColumnDefinition<T, R> definition) {
            Iterator<GroupColumn<?>> iter = this.groupColumns.values().iterator();
            for (GroupColumnDefinition<?, ?> def : GroupBy.this.columnDefinitions) {
                GroupColumn<?> groupColumn = iter.next();
                if (!def.equals(definition)) continue;
                return (R)groupColumn.get();
            }
            throw new NoSuchElementException(definition.toString());
        }

        @Override
        public <T> List<T> getList(Expression<T> expr) {
            return (List)this.get(expr);
        }

        @Override
        public <K, V> Map<K, V> getMap(Expression<K> key, Expression<V> value) {
            for (QPair pair : GroupBy.this.maps) {
                if (!pair.equals(key, value)) continue;
                return (Map)this.groupColumns.get(pair).get();
            }
            throw new NoSuchElementException("GMap(" + key + ", " + value + ")");
        }

        @Override
        public <T> T getOne(Expression<T> expr) {
            return (T)this.get(expr);
        }

        @Override
        public <T> Set<T> getSet(Expression<T> expr) {
            return (Set)this.get(expr);
        }

        @Override
        public Object[] toArray() {
            ArrayList arr = new ArrayList(this.groupColumns.size());
            for (GroupColumn<?> col : this.groupColumns.values()) {
                arr.add(col.get());
            }
            return arr.toArray();
        }
    }

    private static class GOne<T>
    extends AbstractGroupColumnDefinition<T, T> {
        public GOne(Expression<T> expr) {
            super(expr);
        }

        @Override
        public GroupColumn<T> createGroupColumn() {
            return new GroupColumn<T>(){
                private boolean first = true;
                private T val;

                @Override
                public void add(Object o) {
                    if (this.first) {
                        this.val = o;
                        this.first = false;
                    }
                }

                @Override
                public T get() {
                    return this.val;
                }
            };
        }
    }

    private static class GMap<K, V>
    extends AbstractGroupColumnDefinition<Pair<K, V>, Map<K, V>> {
        public GMap(QPair<K, V> qpair) {
            super(qpair);
        }

        @Override
        public GroupColumn<Map<K, V>> createGroupColumn() {
            return new GroupColumn<Map<K, V>>(){
                private final Map<K, V> set = new LinkedHashMap();

                @Override
                public void add(Object o) {
                    Pair pair = (Pair)o;
                    this.set.put(pair.getFirst(), pair.getSecond());
                }

                @Override
                public Map<K, V> get() {
                    return this.set;
                }
            };
        }
    }

    private static class GList<T>
    extends AbstractGroupColumnDefinition<T, List<T>> {
        public GList(Expression<T> expr) {
            super(expr);
        }

        @Override
        public GroupColumn<List<T>> createGroupColumn() {
            return new GroupColumn<List<T>>(){
                private final List<T> list = new ArrayList();

                @Override
                public void add(Object o) {
                    this.list.add(o);
                }

                @Override
                public List<T> get() {
                    return this.list;
                }
            };
        }
    }
}

