/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.SimpleExpression;

public class Param<T>
extends SimpleExpression<T>
implements ParamExpression<T> {
    private static final long serialVersionUID = -6872502615009012503L;
    private static volatile long counter = 0L;
    private final String name;
    private final boolean anon;

    public Param(Class<? extends T> type, String name) {
        super(type);
        this.name = (String)Assert.notNull((Object)name, (String)"name");
        this.anon = false;
    }

    public Param(Class<? extends T> type) {
        super(type);
        this.name = "param" + ++counter;
        this.anon = true;
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Param) {
            Param other = (Param)o;
            return other.getType().equals(this.getType()) && other.getName().equals(this.name) && other.anon == this.anon;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAnon() {
        return this.anon;
    }

    @Override
    public String getNotSetMessage() {
        if (!this.anon) {
            return "The parameter " + this.name + " needs to be set";
        }
        return "A parameter of type " + this.getType().getName() + " was not set";
    }
}

