/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.mysema.commons.lang.Assert;
import com.mysema.query.QueryMetadata;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.NullExpression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.ComparableExpression;
import com.mysema.query.types.expr.DateExpression;
import com.mysema.query.types.expr.DateTimeExpression;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.StringExpression;
import com.mysema.query.types.expr.TimeExpression;
import com.mysema.query.types.expr.Wildcard;
import com.mysema.query.types.query.BooleanSubQuery;
import com.mysema.query.types.query.ComparableSubQuery;
import com.mysema.query.types.query.DateSubQuery;
import com.mysema.query.types.query.DateTimeSubQuery;
import com.mysema.query.types.query.Detachable;
import com.mysema.query.types.query.ListSubQuery;
import com.mysema.query.types.query.NumberSubQuery;
import com.mysema.query.types.query.SimpleSubQuery;
import com.mysema.query.types.query.StringSubQuery;
import com.mysema.query.types.query.TimeSubQuery;
import javax.annotation.Nullable;

public class DetachableMixin
implements Detachable {
    private final QueryMixin<?> queryMixin;

    public DetachableMixin(QueryMixin<?> queryMixin) {
        this.queryMixin = (QueryMixin)Assert.notNull(queryMixin, (String)"queryMixin");
    }

    @Override
    public NumberSubQuery<Long> count() {
        return new NumberSubQuery<Long>(Long.class, this.projection(Wildcard.count));
    }

    @Override
    public BooleanExpression exists() {
        if (this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("No sources given");
        }
        return this.unique(this.queryMixin.getMetadata().getJoins().get(0).getTarget()).exists();
    }

    @Override
    public ListSubQuery<Object[]> list(Expression<?> first, Expression<?> second, Expression<?> ... rest) {
        return new ListSubQuery<Object[]>(Object[].class, this.projection(first, second, rest));
    }

    @Override
    public ListSubQuery<Object[]> list(Expression<?>[] args) {
        return new ListSubQuery<Object[]>(Object[].class, this.projection(args));
    }

    @Override
    public <RT> ListSubQuery<RT> list(Expression<RT> projection) {
        return new ListSubQuery<RT>(projection.getType(), this.projection(projection));
    }

    @Override
    public ListSubQuery<Object[]> list(Object ... args) {
        return this.list(this.convert(args));
    }

    @Override
    public SimpleSubQuery<Object[]> unique(Object ... args) {
        return this.unique(this.convert(args));
    }

    private Expression<?>[] convert(Object ... args) {
        Expression[] exprs = new Expression[args.length];
        for (int i = 0; i < exprs.length; ++i) {
            exprs[i] = args[i] instanceof Expression ? (Expression)args[i] : (args[i] != null ? new ConstantImpl<Object>(args[i]) : NullExpression.DEFAULT);
        }
        return exprs;
    }

    @Override
    public BooleanExpression notExists() {
        return this.exists().not();
    }

    private QueryMetadata projection(Expression<?> ... projection) {
        QueryMetadata metadata = this.queryMixin.getMetadata().clone();
        for (Expression<?> expr : projection) {
            metadata.addProjection(this.nullAsTemplate(expr));
        }
        return metadata;
    }

    private QueryMetadata projection(Expression<?> first, Expression<?> second, Expression<?>[] rest) {
        QueryMetadata metadata = this.queryMixin.getMetadata().clone();
        metadata.addProjection(this.nullAsTemplate(first));
        metadata.addProjection(this.nullAsTemplate(second));
        for (Expression<?> expr : rest) {
            metadata.addProjection(this.nullAsTemplate(expr));
        }
        return metadata;
    }

    private Expression<?> nullAsTemplate(@Nullable Expression<?> expr) {
        return expr != null ? expr : NullExpression.DEFAULT;
    }

    @Override
    public <RT extends Comparable<?>> ComparableSubQuery<RT> unique(ComparableExpression<RT> projection) {
        return new ComparableSubQuery(projection.getType(), this.uniqueProjection(projection));
    }

    @Override
    public <RT extends Comparable<?>> DateSubQuery<RT> unique(DateExpression<RT> projection) {
        return new DateSubQuery(projection.getType(), this.uniqueProjection(projection));
    }

    @Override
    public <RT extends Comparable<?>> DateTimeSubQuery<RT> unique(DateTimeExpression<RT> projection) {
        return new DateTimeSubQuery(projection.getType(), this.uniqueProjection(projection));
    }

    @Override
    public SimpleSubQuery<Object[]> unique(Expression<?> first, Expression<?> second, Expression<?> ... rest) {
        return new SimpleSubQuery<Object[]>(Object[].class, this.uniqueProjection(first, second, rest));
    }

    @Override
    public SimpleSubQuery<Object[]> unique(Expression<?>[] args) {
        return new SimpleSubQuery<Object[]>(Object[].class, this.uniqueProjection(args));
    }

    @Override
    public <RT> SimpleSubQuery<RT> unique(Expression<RT> projection) {
        return new SimpleSubQuery<RT>(projection.getType(), this.uniqueProjection(projection));
    }

    @Override
    public <RT extends Number> NumberSubQuery<RT> unique(NumberExpression<RT> projection) {
        return new NumberSubQuery(projection.getType(), this.uniqueProjection(projection));
    }

    @Override
    public BooleanSubQuery unique(Predicate projection) {
        return new BooleanSubQuery(this.uniqueProjection(projection));
    }

    @Override
    public StringSubQuery unique(StringExpression projection) {
        return new StringSubQuery(this.uniqueProjection(projection));
    }

    @Override
    public <RT extends Comparable<?>> TimeSubQuery<RT> unique(TimeExpression<RT> projection) {
        return new TimeSubQuery(projection.getType(), this.uniqueProjection(projection));
    }

    private QueryMetadata uniqueProjection(Expression<?> ... projection) {
        QueryMetadata metadata = this.projection(projection);
        metadata.setUnique(true);
        return metadata;
    }

    private QueryMetadata uniqueProjection(Expression<?> first, Expression<?> second, Expression<?>[] rest) {
        QueryMetadata metadata = this.projection(first, second, rest);
        metadata.setUnique(true);
        return metadata;
    }
}

