/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.expr.DateOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.TemporalExpression;
import java.util.Date;
import javax.annotation.Nullable;

public abstract class DateExpression<D extends Comparable>
extends TemporalExpression<D> {
    private static final DateExpression<Date> CURRENT_DATE = DateExpression.currentDate(Date.class);
    private static final long serialVersionUID = 6054664454254721302L;
    @Nullable
    private volatile NumberExpression<Integer> dayOfMonth;
    @Nullable
    private volatile NumberExpression<Integer> dayOfWeek;
    @Nullable
    private volatile NumberExpression<Integer> dayOfYear;
    @Nullable
    private volatile DateExpression min;
    @Nullable
    private volatile DateExpression max;
    @Nullable
    private volatile NumberExpression<Integer> week;
    @Nullable
    private volatile NumberExpression<Integer> month;
    @Nullable
    private volatile NumberExpression<Integer> year;
    @Nullable
    private volatile NumberExpression<Integer> yearMonth;

    public static DateExpression<Date> currentDate() {
        return CURRENT_DATE;
    }

    public static <T extends Comparable> DateExpression<T> currentDate(Class<T> cl) {
        return DateOperation.create(cl, Ops.DateTimeOps.CURRENT_DATE, new Expression[0]);
    }

    public DateExpression(Class<? extends D> type) {
        super(type);
    }

    @Override
    public DateExpression<D> as(Path<D> alias) {
        return DateOperation.create(this.getType(), Ops.ALIAS, this, alias);
    }

    @Override
    public DateExpression as(String alias) {
        return DateOperation.create(this.getType(), Ops.ALIAS, this, new PathImpl(this.getType(), alias));
    }

    public NumberExpression<Integer> dayOfMonth() {
        if (this.dayOfMonth == null) {
            this.dayOfMonth = NumberOperation.create(Integer.class, Ops.DateTimeOps.DAY_OF_MONTH, this);
        }
        return this.dayOfMonth;
    }

    public NumberExpression<Integer> dayOfWeek() {
        if (this.dayOfWeek == null) {
            this.dayOfWeek = NumberOperation.create(Integer.class, Ops.DateTimeOps.DAY_OF_WEEK, this);
        }
        return this.dayOfWeek;
    }

    public NumberExpression<Integer> dayOfYear() {
        if (this.dayOfYear == null) {
            this.dayOfYear = NumberOperation.create(Integer.class, Ops.DateTimeOps.DAY_OF_YEAR, this);
        }
        return this.dayOfYear;
    }

    public DateExpression<D> max() {
        if (this.max == null) {
            this.max = DateOperation.create(this.getType(), Ops.AggOps.MAX_AGG, this);
        }
        return this.max;
    }

    public DateExpression<D> min() {
        if (this.min == null) {
            this.min = DateOperation.create(this.getType(), Ops.AggOps.MIN_AGG, this);
        }
        return this.min;
    }

    public NumberExpression<Integer> month() {
        if (this.month == null) {
            this.month = NumberOperation.create(Integer.class, Ops.DateTimeOps.MONTH, this);
        }
        return this.month;
    }

    public NumberExpression<Integer> week() {
        if (this.week == null) {
            this.week = NumberOperation.create(Integer.class, Ops.DateTimeOps.WEEK, this);
        }
        return this.week;
    }

    public NumberExpression<Integer> year() {
        if (this.year == null) {
            this.year = NumberOperation.create(Integer.class, Ops.DateTimeOps.YEAR, this);
        }
        return this.year;
    }

    public NumberExpression<Integer> yearMonth() {
        if (this.yearMonth == null) {
            this.yearMonth = NumberOperation.create(Integer.class, Ops.DateTimeOps.YEAR_MONTH, this);
        }
        return this.yearMonth;
    }
}

