/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.expr.StringExpression;
import com.mysema.query.types.expr.StringOperation;
import javax.annotation.Nullable;

public abstract class ComparableExpressionBase<D extends Comparable>
extends SimpleExpression<D> {
    private static final long serialVersionUID = 1460921109546656911L;
    @Nullable
    private volatile OrderSpecifier<D> asc;
    @Nullable
    private volatile OrderSpecifier<D> desc;
    @Nullable
    private volatile StringExpression stringCast;

    public ComparableExpressionBase(Class<? extends D> type) {
        super(type);
    }

    public final OrderSpecifier<D> asc() {
        if (this.asc == null) {
            this.asc = new OrderSpecifier(Order.ASC, this);
        }
        return this.asc;
    }

    public <A extends Number> NumberExpression<A> castToNum(Class<A> type) {
        return NumberOperation.create(type, Ops.NUMCAST, this, new ConstantImpl<Class<A>>(type));
    }

    public final OrderSpecifier<D> desc() {
        if (this.desc == null) {
            this.desc = new OrderSpecifier(Order.DESC, this);
        }
        return this.desc;
    }

    public StringExpression stringValue() {
        if (this.stringCast == null) {
            this.stringCast = StringOperation.create(Ops.STRING_CAST, this);
        }
        return this.stringCast;
    }
}

