/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Visitor;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;

public class ArrayConstructorExpression<D>
extends ExpressionBase<D[]>
implements FactoryExpression<D[]> {
    private static final long serialVersionUID = 8667880104290226505L;
    private final Class<D> elementType;
    private final List<Expression<?>> args;

    public ArrayConstructorExpression(Expression<?> ... args) {
        this(Object[].class, args);
    }

    public ArrayConstructorExpression(Class<D[]> type, Expression<D> ... args) {
        super(type);
        this.elementType = (Class)Assert.notNull(type.getComponentType(), (String)"componentType");
        this.args = Arrays.asList(args);
    }

    public final Class<D> getElementType() {
        return this.elementType;
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    @Override
    public D[] newInstance(Object ... args) {
        if (args.getClass().getComponentType().equals(this.elementType)) {
            return args;
        }
        Object[] rv = (Object[])Array.newInstance(this.elementType, args.length);
        System.arraycopy(args, 0, rv, 0, args.length);
        return rv;
    }

    @Override
    public List<Expression<?>> getArgs() {
        return this.args;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArrayConstructorExpression) {
            ArrayConstructorExpression c = (ArrayConstructorExpression)obj;
            return ((Object)this.args).equals(c.args) && this.getType().equals(c.getType());
        }
        return false;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }
}

