/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.mysema.commons.lang.Assert;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinType;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.MapExpression;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Ops;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.SubQueryExpression;

public class QueryMixin<T> {
    private final QueryMetadata metadata;
    private T self;

    public QueryMixin() {
        this.metadata = new DefaultQueryMetadata();
    }

    public QueryMixin(QueryMetadata metadata) {
        this.metadata = (QueryMetadata)Assert.notNull((Object)metadata, (String)"metadata");
    }

    public QueryMixin(T self) {
        this(self, new DefaultQueryMetadata());
    }

    public QueryMixin(T self, QueryMetadata metadata) {
        this.self = Assert.notNull(self, (String)"self");
        this.metadata = (QueryMetadata)Assert.notNull((Object)metadata, (String)"metadata");
    }

    public T addFlag(QueryFlag queryFlag) {
        this.metadata.addFlag(queryFlag);
        return this.self;
    }

    public T addToProjection(Expression<?> ... o) {
        this.metadata.addProjection(o);
        return this.self;
    }

    private <P extends Path<?>> P assertRoot(P p) {
        if (!p.getRoot().equals(p)) {
            throw new IllegalArgumentException(p + " is not a root path");
        }
        return p;
    }

    protected <D> Expression<D> createAlias(Expression<D> path, Path<D> alias) {
        this.assertRoot(alias);
        return ExpressionUtils.as(path, alias);
    }

    protected <D> Expression<D> createAlias(CollectionExpression<?, D> target, Path<D> alias) {
        this.assertRoot(alias);
        return OperationImpl.create(alias.getType(), Ops.ALIAS, target, alias);
    }

    protected <D> Expression<D> createAlias(MapExpression<?, D> target, Path<D> alias) {
        this.assertRoot(alias);
        return OperationImpl.create(alias.getType(), Ops.ALIAS, target, alias);
    }

    protected <D> Expression<D> createAlias(SubQueryExpression<D> path, Path<D> alias) {
        this.assertRoot(alias);
        return ExpressionUtils.as(path, alias);
    }

    public T from(Expression<?> ... args) {
        for (Expression<?> arg : args) {
            this.metadata.addJoin(JoinType.DEFAULT, arg);
        }
        return this.self;
    }

    public T from(EntityPath<?> ... args) {
        for (EntityPath<?> arg : args) {
            this.metadata.addJoin(JoinType.DEFAULT, arg);
        }
        return this.self;
    }

    public <P> T fullJoin(EntityPath<P> target) {
        this.metadata.addJoin(JoinType.FULLJOIN, target);
        return this.self;
    }

    public <P> T fullJoin(EntityPath<P> target, EntityPath<P> alias) {
        this.metadata.addJoin(JoinType.FULLJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public <P> T fullJoin(CollectionExpression<?, P> target) {
        this.metadata.addJoin(JoinType.FULLJOIN, target);
        return this.self;
    }

    public <P> T fullJoin(CollectionExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.FULLJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public <P> T fullJoin(MapExpression<?, P> target) {
        this.metadata.addJoin(JoinType.FULLJOIN, target);
        return this.self;
    }

    public <P> T fullJoin(MapExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.FULLJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public <P> T fullJoin(SubQueryExpression<P> target, Path alias) {
        this.metadata.addJoin(JoinType.FULLJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public QueryMetadata getMetadata() {
        return this.metadata;
    }

    public T getSelf() {
        return this.self;
    }

    public T groupBy(Expression<?> ... o) {
        this.metadata.addGroupBy(o);
        return this.self;
    }

    public T having(Predicate ... o) {
        this.metadata.addHaving(o);
        return this.self;
    }

    public <P> T innerJoin(EntityPath<P> target) {
        this.metadata.addJoin(JoinType.INNERJOIN, target);
        return this.self;
    }

    public <P> T innerJoin(EntityPath<P> target, EntityPath<P> alias) {
        this.metadata.addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public <P> T innerJoin(CollectionExpression<?, P> target) {
        this.metadata.addJoin(JoinType.INNERJOIN, target);
        return this.self;
    }

    public <P> T innerJoin(CollectionExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public <P> T innerJoin(MapExpression<?, P> target) {
        this.metadata.addJoin(JoinType.INNERJOIN, target);
        return this.self;
    }

    public <P> T innerJoin(MapExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public <P> T innerJoin(SubQueryExpression<P> target, Path alias) {
        this.metadata.addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public boolean isDistinct() {
        return this.metadata.isDistinct();
    }

    public boolean isUnique() {
        return this.metadata.isUnique();
    }

    public <P> T join(EntityPath<P> target) {
        this.metadata.addJoin(JoinType.JOIN, target);
        return this.self;
    }

    public <P> T join(EntityPath<P> target, EntityPath<P> alias) {
        this.metadata.addJoin(JoinType.JOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public <P> T join(CollectionExpression<?, P> target) {
        this.metadata.addJoin(JoinType.JOIN, target);
        return this.getSelf();
    }

    public <P> T join(CollectionExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.JOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public <P> T join(MapExpression<?, P> target) {
        this.metadata.addJoin(JoinType.JOIN, target);
        return this.getSelf();
    }

    public <P> T join(MapExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.JOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public <P> T join(SubQueryExpression<P> target, Path alias) {
        this.metadata.addJoin(JoinType.JOIN, this.createAlias(target, alias));
        return this.self;
    }

    public <P> T leftJoin(EntityPath<P> target) {
        this.metadata.addJoin(JoinType.LEFTJOIN, target);
        return this.self;
    }

    public <P> T leftJoin(EntityPath<P> target, EntityPath<P> alias) {
        this.metadata.addJoin(JoinType.LEFTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public <P> T leftJoin(CollectionExpression<?, P> target) {
        this.metadata.addJoin(JoinType.LEFTJOIN, target);
        return this.getSelf();
    }

    public <P> T leftJoin(CollectionExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.LEFTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public <P> T leftJoin(MapExpression<?, P> target) {
        this.metadata.addJoin(JoinType.LEFTJOIN, target);
        return this.getSelf();
    }

    public <P> T leftJoin(MapExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.LEFTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public <P> T leftJoin(SubQueryExpression<P> target, Path alias) {
        this.metadata.addJoin(JoinType.LEFTJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public T limit(long limit) {
        this.metadata.setLimit(limit);
        return this.self;
    }

    public T offset(long offset) {
        this.metadata.setOffset(offset);
        return this.self;
    }

    public T on(Predicate ... conditions) {
        for (Predicate condition : conditions) {
            this.metadata.addJoinCondition(condition);
        }
        return this.self;
    }

    public T orderBy(OrderSpecifier<?> ... o) {
        this.metadata.addOrderBy(o);
        return this.self;
    }

    public T restrict(QueryModifiers modifiers) {
        this.metadata.setModifiers(modifiers);
        return this.self;
    }

    public <P> T rightJoin(EntityPath<P> target) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, target);
        return this.self;
    }

    public <P> T rightJoin(EntityPath<P> target, EntityPath<P> alias) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public <P> T rightJoin(CollectionExpression<?, P> target) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, target);
        return this.getSelf();
    }

    public <P> T rightJoin(CollectionExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public <P> T rightJoin(MapExpression<?, P> target) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, target);
        return this.getSelf();
    }

    public <P> T rightJoin(MapExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public <P> T rightJoin(SubQueryExpression<P> target, Path alias) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public <P> T set(ParamExpression<P> param, P value) {
        this.metadata.setParam(param, value);
        return this.self;
    }

    public void setDistinct(boolean distinct) {
        this.metadata.setDistinct(distinct);
    }

    public void setSelf(T self) {
        this.self = self;
    }

    public void setUnique(boolean unique) {
        this.metadata.setUnique(unique);
    }

    public String toString() {
        return this.metadata.toString();
    }

    public T where(Predicate ... o) {
        this.metadata.addWhere(o);
        return this.self;
    }
}

