/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import com.microsoft.azure.spring.autoconfigure.aad.ServiceEndpoints;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration
@ConfigurationProperties(value="azure.service")
public class ServiceEndpointsProperties {
    private Map<String, ServiceEndpoints> endpoints = new HashMap<String, ServiceEndpoints>();

    public Map<String, ServiceEndpoints> getEndpoints() {
        return this.endpoints;
    }

    public ServiceEndpoints getServiceEndpoints(String environment) {
        Assert.notEmpty(this.endpoints, (String)"No service endpoints found");
        if (!this.endpoints.containsKey(environment)) {
            throw new IllegalArgumentException(environment + " is not found in the configuration, only following environments are supported: " + this.endpoints.keySet());
        }
        return this.endpoints.get(environment);
    }
}

