/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import com.microsoft.aad.msal4j.MsalServiceException;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;

public class AADAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private AuthenticationFailureHandler defaultHandler = new SimpleUrlAuthenticationFailureHandler("/login?error");

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        Throwable cause;
        OAuth2AuthenticationException targetException = (OAuth2AuthenticationException)exception;
        if ("conditional_access_policy".equals(targetException.getError().getErrorCode()) && (cause = targetException.getCause()) instanceof MsalServiceException) {
            Optional.of(cause).map(c -> (MsalServiceException)((Object)c)).map(MsalServiceException::claims).ifPresent(claims -> request.getSession().setAttribute("CAP_Claims", claims));
            String redirectUrl = Optional.of(request).map(HttpServletRequest::getSession).map(s -> s.getAttribute("SPRING_SECURITY_SAVED_REQUEST")).map(r -> (DefaultSavedRequest)r).map(DefaultSavedRequest::getRedirectUrl).orElse(null);
            response.sendRedirect(redirectUrl);
            response.setStatus(302);
            return;
        }
        this.defaultHandler.onAuthenticationFailure(request, response, exception);
    }
}

