/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.azure.core.exception.HttpRequestException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.core.util.paging.ContinuablePagedIterable;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class KeyVaultOperation {
    private static final Logger LOG = LoggerFactory.getLogger(KeyVaultOperation.class);
    private final boolean caseSensitive;
    private Map<String, String> properties = new HashMap<String, String>();
    private final SecretClient secretClient;
    private final List<String> secretKeys;

    public KeyVaultOperation(SecretClient secretClient, long refreshInMillis, List<String> secretKeys, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.secretClient = secretClient;
        this.secretKeys = secretKeys;
        this.refreshProperties();
        if (refreshInMillis > 0L) {
            Timer timer = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    KeyVaultOperation.this.refreshProperties();
                }
            };
            timer.scheduleAtFixedRate(task, refreshInMillis, refreshInMillis);
        }
    }

    public String getProperty(String property) {
        return this.properties.get(this.toKeyVaultSecretName(property));
    }

    public String[] getPropertyNames() {
        if (!this.caseSensitive) {
            return (String[])this.properties.keySet().stream().flatMap(p -> Stream.of(p, p.replaceAll("-", "."))).distinct().toArray(String[]::new);
        }
        return this.properties.keySet().toArray(new String[0]);
    }

    private void refreshProperties() {
        this.properties = this.secretKeys == null || this.secretKeys.isEmpty() ? Optional.of(this.secretClient).map(SecretClient::listPropertiesOfSecrets).map(ContinuablePagedIterable::iterableByPage).map(i -> StreamSupport.stream(i.spliterator(), false)).orElseGet(Stream::empty).map(ContinuablePage::getElements).flatMap(i -> StreamSupport.stream(i.spliterator(), false)).filter(SecretProperties::isEnabled).map(p -> this.secretClient.getSecret(p.getName(), p.getVersion())).filter(Objects::nonNull).collect(Collectors.toMap(s -> this.toKeyVaultSecretName(s.getName()), KeyVaultSecret::getValue)) : this.secretKeys.stream().map(this::toKeyVaultSecretName).map(arg_0 -> ((SecretClient)this.secretClient).getSecret(arg_0)).filter(Objects::nonNull).collect(Collectors.toMap(s -> this.toKeyVaultSecretName(s.getName()), KeyVaultSecret::getValue));
    }

    private String toKeyVaultSecretName(@NonNull String property) {
        if (!this.caseSensitive) {
            if (property.matches("[a-z0-9A-Z-]+")) {
                return property.toLowerCase(Locale.US);
            }
            if (property.matches("[A-Z0-9_]+")) {
                return property.toLowerCase(Locale.US).replaceAll("_", "-");
            }
            return property.toLowerCase(Locale.US).replaceAll("-", "").replaceAll("_", "").replaceAll("\\.", "-");
        }
        return property;
    }

    void setProperties(HashMap<String, String> properties) {
        this.properties = properties;
    }

    boolean isUp() {
        boolean result;
        try {
            Response response = this.secretClient.getSecretWithResponse("it-is-ok-to-be-empty", null, Context.NONE);
            result = response.getStatusCode() < 500;
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            result = true;
        }
        catch (HttpRequestException httpRequestException) {
            LOG.error("An HTTP error occurred while checking key vault connectivity", (Throwable)httpRequestException);
            result = true;
        }
        catch (RuntimeException runtimeException) {
            LOG.error("A runtime error occurred while checking key vault connectivity", (Throwable)runtimeException);
            result = false;
        }
        return result;
    }
}

